@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.marketplace.kotlin.inputs

import com.pulumi.azurenative.marketplace.inputs.ListPrivateStoreNewPlansNotificationsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property privateStoreId The store ID - must use the tenant ID
 */
public data class ListPrivateStoreNewPlansNotificationsPlainArgs(
    public val privateStoreId: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.marketplace.inputs.ListPrivateStoreNewPlansNotificationsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.marketplace.inputs.ListPrivateStoreNewPlansNotificationsPlainArgs =
        com.pulumi.azurenative.marketplace.inputs.ListPrivateStoreNewPlansNotificationsPlainArgs.builder()
            .privateStoreId(privateStoreId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListPrivateStoreNewPlansNotificationsPlainArgs].
 */
@PulumiTagMarker
public class ListPrivateStoreNewPlansNotificationsPlainArgsBuilder internal constructor() {
    private var privateStoreId: String? = null

    /**
     * @param value The store ID - must use the tenant ID
     */
    @JvmName("jyrajotnkrwatuyv")
    public suspend fun privateStoreId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateStoreId = mapped
    }

    internal fun build(): ListPrivateStoreNewPlansNotificationsPlainArgs =
        ListPrivateStoreNewPlansNotificationsPlainArgs(
            privateStoreId = privateStoreId ?: throw PulumiNullFieldException("privateStoreId"),
        )
}
