@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.marketplace.kotlin.inputs

import com.pulumi.azurenative.marketplace.inputs.ListPrivateStoreSubscriptionsContextPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property privateStoreId The store ID - must use the tenant ID
 */
public data class ListPrivateStoreSubscriptionsContextPlainArgs(
    public val privateStoreId: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.marketplace.inputs.ListPrivateStoreSubscriptionsContextPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.marketplace.inputs.ListPrivateStoreSubscriptionsContextPlainArgs =
        com.pulumi.azurenative.marketplace.inputs.ListPrivateStoreSubscriptionsContextPlainArgs.builder()
            .privateStoreId(privateStoreId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListPrivateStoreSubscriptionsContextPlainArgs].
 */
@PulumiTagMarker
public class ListPrivateStoreSubscriptionsContextPlainArgsBuilder internal constructor() {
    private var privateStoreId: String? = null

    /**
     * @param value The store ID - must use the tenant ID
     */
    @JvmName("sxyfgxhlivepvryp")
    public suspend fun privateStoreId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateStoreId = mapped
    }

    internal fun build(): ListPrivateStoreSubscriptionsContextPlainArgs =
        ListPrivateStoreSubscriptionsContextPlainArgs(
            privateStoreId = privateStoreId ?: throw PulumiNullFieldException("privateStoreId"),
        )
}
