@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.marketplace.kotlin.inputs

import com.pulumi.azurenative.marketplace.inputs.PlanArgs.builder
import com.pulumi.azurenative.marketplace.kotlin.enums.Accessibility
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accessibility Plan accessibility
 */
public data class PlanArgs(
    public val accessibility: Output<Either<String, Accessibility>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.marketplace.inputs.PlanArgs> {
    override fun toJava(): com.pulumi.azurenative.marketplace.inputs.PlanArgs =
        com.pulumi.azurenative.marketplace.inputs.PlanArgs.builder()
            .accessibility(
                accessibility?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [PlanArgs].
 */
@PulumiTagMarker
public class PlanArgsBuilder internal constructor() {
    private var accessibility: Output<Either<String, Accessibility>>? = null

    /**
     * @param value Plan accessibility
     */
    @JvmName("hnfsuclekveulmlv")
    public suspend fun accessibility(`value`: Output<Either<String, Accessibility>>) {
        this.accessibility = value
    }

    /**
     * @param value Plan accessibility
     */
    @JvmName("xymqxbmsfusxifpx")
    public suspend fun accessibility(`value`: Either<String, Accessibility>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessibility = mapped
    }

    /**
     * @param value Plan accessibility
     */
    @JvmName("klcioxktavfpdnxr")
    public fun accessibility(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Accessibility>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessibility = mapped
    }

    /**
     * @param value Plan accessibility
     */
    @JvmName("fcoawykjplxtnduh")
    public fun accessibility(`value`: Accessibility) {
        val toBeMapped = Either.ofRight<String, Accessibility>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessibility = mapped
    }

    internal fun build(): PlanArgs = PlanArgs(
        accessibility = accessibility,
    )
}
