@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.marketplace.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * New plans notification details
 * @property displayName Gets offer display name
 * @property icon Gets or sets the icon url
 * @property isFuturePlansEnabled Gets a value indicating whether future plans is enabled.
 * @property messageCode Gets or sets the notification message id
 * @property offerId Gets offer id
 * @property plans Gets or sets removed plans notifications
 */
public data class NewNotificationsResponse(
    public val displayName: String? = null,
    public val icon: String? = null,
    public val isFuturePlansEnabled: Boolean? = null,
    public val messageCode: Double? = null,
    public val offerId: String? = null,
    public val plans: List<PlanNotificationDetailsResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.marketplace.outputs.NewNotificationsResponse): NewNotificationsResponse = NewNotificationsResponse(
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            icon = javaType.icon().map({ args0 -> args0 }).orElse(null),
            isFuturePlansEnabled = javaType.isFuturePlansEnabled().map({ args0 -> args0 }).orElse(null),
            messageCode = javaType.messageCode().map({ args0 -> args0 }).orElse(null),
            offerId = javaType.offerId().map({ args0 -> args0 }).orElse(null),
            plans = javaType.plans().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.marketplace.kotlin.outputs.PlanNotificationDetailsResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
