@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin

import com.pulumi.azurenative.media.AssetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An Asset.
 * Azure REST API version: 2023-01-01. Prior API version in Azure Native 1.x: 2020-05-01.
 * ## Example Usage
 * ### Create an Asset
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var asset = new AzureNative.Media.Asset("asset", new()
 *     {
 *         AccountName = "contosomedia",
 *         AssetName = "ClimbingMountLogan",
 *         Description = "A documentary showing the ascent of Mount Logan",
 *         ResourceGroupName = "contosorg",
 *         StorageAccountName = "storage0",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := media.NewAsset(ctx, "asset", &media.AssetArgs{
 * 			AccountName:        pulumi.String("contosomedia"),
 * 			AssetName:          pulumi.String("ClimbingMountLogan"),
 * 			Description:        pulumi.String("A documentary showing the ascent of Mount Logan"),
 * 			ResourceGroupName:  pulumi.String("contosorg"),
 * 			StorageAccountName: pulumi.String("storage0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.Asset;
 * import com.pulumi.azurenative.media.AssetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var asset = new Asset("asset", AssetArgs.builder()
 *             .accountName("contosomedia")
 *             .assetName("ClimbingMountLogan")
 *             .description("A documentary showing the ascent of Mount Logan")
 *             .resourceGroupName("contosorg")
 *             .storageAccountName("storage0")
 *             .build());
 *     }
 * }
 * ```
 * ### Create an Asset with encryption scope
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var asset = new AzureNative.Media.Asset("asset", new()
 *     {
 *         AccountName = "contosomedia",
 *         AssetName = "ClimbingMountLogan",
 *         Description = "A documentary showing the ascent of Mount Logan",
 *         EncryptionScope = "encryptionScope1",
 *         ResourceGroupName = "contosorg",
 *         StorageAccountName = "storage0",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := media.NewAsset(ctx, "asset", &media.AssetArgs{
 * 			AccountName:        pulumi.String("contosomedia"),
 * 			AssetName:          pulumi.String("ClimbingMountLogan"),
 * 			Description:        pulumi.String("A documentary showing the ascent of Mount Logan"),
 * 			EncryptionScope:    pulumi.String("encryptionScope1"),
 * 			ResourceGroupName:  pulumi.String("contosorg"),
 * 			StorageAccountName: pulumi.String("storage0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.Asset;
 * import com.pulumi.azurenative.media.AssetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var asset = new Asset("asset", AssetArgs.builder()
 *             .accountName("contosomedia")
 *             .assetName("ClimbingMountLogan")
 *             .description("A documentary showing the ascent of Mount Logan")
 *             .encryptionScope("encryptionScope1")
 *             .resourceGroupName("contosorg")
 *             .storageAccountName("storage0")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:media:Asset ClimbingMountLogan /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/assets/{assetName}
 * ```
 * @property accountName The Media Services account name.
 * @property alternateId The alternate ID of the Asset.
 * @property assetName The Asset name.
 * @property container The name of the asset blob container.
 * @property description The Asset description.
 * @property encryptionScope The Asset container encryption scope in the storage account.
 * @property resourceGroupName The name of the resource group within the Azure subscription.
 * @property storageAccountName The name of the storage account.
 */
public data class AssetArgs(
    public val accountName: Output<String>? = null,
    public val alternateId: Output<String>? = null,
    public val assetName: Output<String>? = null,
    public val container: Output<String>? = null,
    public val description: Output<String>? = null,
    public val encryptionScope: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val storageAccountName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.AssetArgs> {
    override fun toJava(): com.pulumi.azurenative.media.AssetArgs =
        com.pulumi.azurenative.media.AssetArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .alternateId(alternateId?.applyValue({ args0 -> args0 }))
            .assetName(assetName?.applyValue({ args0 -> args0 }))
            .container(container?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encryptionScope(encryptionScope?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .storageAccountName(storageAccountName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AssetArgs].
 */
@PulumiTagMarker
public class AssetArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var alternateId: Output<String>? = null

    private var assetName: Output<String>? = null

    private var container: Output<String>? = null

    private var description: Output<String>? = null

    private var encryptionScope: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var storageAccountName: Output<String>? = null

    /**
     * @param value The Media Services account name.
     */
    @JvmName("xrmhmjclxuphuyeq")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The alternate ID of the Asset.
     */
    @JvmName("aelyrqdlwlixvagi")
    public suspend fun alternateId(`value`: Output<String>) {
        this.alternateId = value
    }

    /**
     * @param value The Asset name.
     */
    @JvmName("ctwnkgwicsveniig")
    public suspend fun assetName(`value`: Output<String>) {
        this.assetName = value
    }

    /**
     * @param value The name of the asset blob container.
     */
    @JvmName("nkjrevedqervkfnx")
    public suspend fun container(`value`: Output<String>) {
        this.container = value
    }

    /**
     * @param value The Asset description.
     */
    @JvmName("ivdaqqhknpyevgjo")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The Asset container encryption scope in the storage account.
     */
    @JvmName("jolqoewgbrggkdve")
    public suspend fun encryptionScope(`value`: Output<String>) {
        this.encryptionScope = value
    }

    /**
     * @param value The name of the resource group within the Azure subscription.
     */
    @JvmName("vsxceigjkevrasbs")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the storage account.
     */
    @JvmName("mbxmrdnxnrxvqawg")
    public suspend fun storageAccountName(`value`: Output<String>) {
        this.storageAccountName = value
    }

    /**
     * @param value The Media Services account name.
     */
    @JvmName("dnerptvxpxxoivij")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The alternate ID of the Asset.
     */
    @JvmName("ceshurrxgrscppkg")
    public suspend fun alternateId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alternateId = mapped
    }

    /**
     * @param value The Asset name.
     */
    @JvmName("bcsjjlmvyueycdkv")
    public suspend fun assetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assetName = mapped
    }

    /**
     * @param value The name of the asset blob container.
     */
    @JvmName("imnbevrwdbgkbnyk")
    public suspend fun container(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.container = mapped
    }

    /**
     * @param value The Asset description.
     */
    @JvmName("mixthnsqpmxocwpl")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The Asset container encryption scope in the storage account.
     */
    @JvmName("hajxfjhfnphvpnkk")
    public suspend fun encryptionScope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionScope = mapped
    }

    /**
     * @param value The name of the resource group within the Azure subscription.
     */
    @JvmName("bbayovnaerymsllg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the storage account.
     */
    @JvmName("bnyftuymfgqtpvsv")
    public suspend fun storageAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountName = mapped
    }

    internal fun build(): AssetArgs = AssetArgs(
        accountName = accountName,
        alternateId = alternateId,
        assetName = assetName,
        container = container,
        description = description,
        encryptionScope = encryptionScope,
        resourceGroupName = resourceGroupName,
        storageAccountName = storageAccountName,
    )
}
