@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin

import com.pulumi.azurenative.media.JobArgs.builder
import com.pulumi.azurenative.media.kotlin.enums.Priority
import com.pulumi.azurenative.media.kotlin.inputs.JobOutputAssetArgs
import com.pulumi.azurenative.media.kotlin.inputs.JobOutputAssetArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A Job resource type. The progress and state can be obtained by polling a Job or subscribing to events using EventGrid.
 * Azure REST API version: 2022-07-01. Prior API version in Azure Native 1.x: 2020-05-01.
 * ## Example Usage
 * ### Create a Job
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var job = new AzureNative.Media.Job("job", new()
 *     {
 *         AccountName = "contosomedia",
 *         CorrelationData =
 *         {
 *             { "Key 2", "Value 2" },
 *             { "key1", "value1" },
 *         },
 *         Input = new AzureNative.Media.Inputs.JobInputAssetArgs
 *         {
 *             AssetName = "job1-InputAsset",
 *             OdataType = "#Microsoft.Media.JobInputAsset",
 *         },
 *         JobName = "job1",
 *         Outputs = new[]
 *         {
 *             new AzureNative.Media.Inputs.JobOutputAssetArgs
 *             {
 *                 AssetName = "job1-OutputAsset",
 *                 OdataType = "#Microsoft.Media.JobOutputAsset",
 *             },
 *         },
 *         ResourceGroupName = "contosoresources",
 *         TransformName = "exampleTransform",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := media.NewJob(ctx, "job", &media.JobArgs{
 * AccountName: pulumi.String("contosomedia"),
 * CorrelationData: pulumi.StringMap{
 * "Key 2": pulumi.String("Value 2"),
 * "key1": pulumi.String("value1"),
 * },
 * Input: media.JobInputAsset{
 * AssetName: "job1-InputAsset",
 * OdataType: "#Microsoft.Media.JobInputAsset",
 * },
 * JobName: pulumi.String("job1"),
 * Outputs: media.JobOutputAssetArray{
 * interface{}{
 * AssetName: pulumi.String("job1-OutputAsset"),
 * OdataType: pulumi.String("#Microsoft.Media.JobOutputAsset"),
 * },
 * },
 * ResourceGroupName: pulumi.String("contosoresources"),
 * TransformName: pulumi.String("exampleTransform"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.Job;
 * import com.pulumi.azurenative.media.JobArgs;
 * import com.pulumi.azurenative.media.inputs.JobOutputAssetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var job = new Job("job", JobArgs.builder()
 *             .accountName("contosomedia")
 *             .correlationData(Map.ofEntries(
 *                 Map.entry("Key 2", "Value 2"),
 *                 Map.entry("key1", "value1")
 *             ))
 *             .input(JobInputAssetArgs.builder()
 *                 .assetName("job1-InputAsset")
 *                 .odataType("#Microsoft.Media.JobInputAsset")
 *                 .build())
 *             .jobName("job1")
 *             .outputs(JobOutputAssetArgs.builder()
 *                 .assetName("job1-OutputAsset")
 *                 .odataType("#Microsoft.Media.JobOutputAsset")
 *                 .build())
 *             .resourceGroupName("contosoresources")
 *             .transformName("exampleTransform")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:media:Job job1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/transforms/{transformName}/jobs/{jobName}
 * ```
 * @property accountName The Media Services account name.
 * @property correlationData Customer provided key, value pairs that will be returned in Job and JobOutput state events.
 * @property description Optional customer supplied description of the Job.
 * @property input The inputs for the Job.
 * @property jobName The Job name.
 * @property outputs The outputs for the Job.
 * @property priority Priority with which the job should be processed. Higher priority jobs are processed before lower priority jobs. If not set, the default is normal.
 * @property resourceGroupName The name of the resource group within the Azure subscription.
 * @property transformName The Transform name.
 */
public data class JobArgs(
    public val accountName: Output<String>? = null,
    public val correlationData: Output<Map<String, String>>? = null,
    public val description: Output<String>? = null,
    public val input: Output<Any>? = null,
    public val jobName: Output<String>? = null,
    public val outputs: Output<List<JobOutputAssetArgs>>? = null,
    public val priority: Output<Either<String, Priority>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val transformName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.JobArgs> {
    override fun toJava(): com.pulumi.azurenative.media.JobArgs =
        com.pulumi.azurenative.media.JobArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .correlationData(
                correlationData?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .input(input?.applyValue({ args0 -> args0 }))
            .jobName(jobName?.applyValue({ args0 -> args0 }))
            .outputs(
                outputs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .priority(
                priority?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .transformName(transformName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JobArgs].
 */
@PulumiTagMarker
public class JobArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var correlationData: Output<Map<String, String>>? = null

    private var description: Output<String>? = null

    private var input: Output<Any>? = null

    private var jobName: Output<String>? = null

    private var outputs: Output<List<JobOutputAssetArgs>>? = null

    private var priority: Output<Either<String, Priority>>? = null

    private var resourceGroupName: Output<String>? = null

    private var transformName: Output<String>? = null

    /**
     * @param value The Media Services account name.
     */
    @JvmName("remkkcwmpdegjhdc")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Customer provided key, value pairs that will be returned in Job and JobOutput state events.
     */
    @JvmName("ubawgcoykmdmhrtk")
    public suspend fun correlationData(`value`: Output<Map<String, String>>) {
        this.correlationData = value
    }

    /**
     * @param value Optional customer supplied description of the Job.
     */
    @JvmName("wosuflapottnvnix")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The inputs for the Job.
     */
    @JvmName("onsrhfkoxkjucsrq")
    public suspend fun input(`value`: Output<Any>) {
        this.input = value
    }

    /**
     * @param value The Job name.
     */
    @JvmName("bydbudejgigxlhfj")
    public suspend fun jobName(`value`: Output<String>) {
        this.jobName = value
    }

    /**
     * @param value The outputs for the Job.
     */
    @JvmName("jmbinutsrnvpgyxl")
    public suspend fun outputs(`value`: Output<List<JobOutputAssetArgs>>) {
        this.outputs = value
    }

    @JvmName("ijbdlhpprhrphskb")
    public suspend fun outputs(vararg values: Output<JobOutputAssetArgs>) {
        this.outputs = Output.all(values.asList())
    }

    /**
     * @param values The outputs for the Job.
     */
    @JvmName("efohdkljnjkhickx")
    public suspend fun outputs(values: List<Output<JobOutputAssetArgs>>) {
        this.outputs = Output.all(values)
    }

    /**
     * @param value Priority with which the job should be processed. Higher priority jobs are processed before lower priority jobs. If not set, the default is normal.
     */
    @JvmName("sauxhkusdmmhppqe")
    public suspend fun priority(`value`: Output<Either<String, Priority>>) {
        this.priority = value
    }

    /**
     * @param value The name of the resource group within the Azure subscription.
     */
    @JvmName("ojeewkpuivwhdsde")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The Transform name.
     */
    @JvmName("eythohemsvqrdsfg")
    public suspend fun transformName(`value`: Output<String>) {
        this.transformName = value
    }

    /**
     * @param value The Media Services account name.
     */
    @JvmName("bdcjkgafdimgiqof")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Customer provided key, value pairs that will be returned in Job and JobOutput state events.
     */
    @JvmName("tbnjegjkwibhjvak")
    public suspend fun correlationData(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.correlationData = mapped
    }

    /**
     * @param values Customer provided key, value pairs that will be returned in Job and JobOutput state events.
     */
    @JvmName("otorcuguduvtdeow")
    public fun correlationData(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.correlationData = mapped
    }

    /**
     * @param value Optional customer supplied description of the Job.
     */
    @JvmName("tcbvpckhsxaxqege")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The inputs for the Job.
     */
    @JvmName("likslaiughyqypgl")
    public suspend fun input(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.input = mapped
    }

    /**
     * @param value The Job name.
     */
    @JvmName("pewtkcjqqpyfosti")
    public suspend fun jobName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobName = mapped
    }

    /**
     * @param value The outputs for the Job.
     */
    @JvmName("vbyhhdqfsckibxqk")
    public suspend fun outputs(`value`: List<JobOutputAssetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputs = mapped
    }

    /**
     * @param argument The outputs for the Job.
     */
    @JvmName("nothcbafihrqwikj")
    public suspend fun outputs(argument: List<suspend JobOutputAssetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            JobOutputAssetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.outputs = mapped
    }

    /**
     * @param argument The outputs for the Job.
     */
    @JvmName("rtmjhubeqnutykwm")
    public suspend fun outputs(vararg argument: suspend JobOutputAssetArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            JobOutputAssetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.outputs = mapped
    }

    /**
     * @param argument The outputs for the Job.
     */
    @JvmName("fiveyatgaerpjdit")
    public suspend fun outputs(argument: suspend JobOutputAssetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(JobOutputAssetArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.outputs = mapped
    }

    /**
     * @param values The outputs for the Job.
     */
    @JvmName("carsvxoghwqfdfnq")
    public suspend fun outputs(vararg values: JobOutputAssetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outputs = mapped
    }

    /**
     * @param value Priority with which the job should be processed. Higher priority jobs are processed before lower priority jobs. If not set, the default is normal.
     */
    @JvmName("qwqjdgphqqwrwsbt")
    public suspend fun priority(`value`: Either<String, Priority>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value Priority with which the job should be processed. Higher priority jobs are processed before lower priority jobs. If not set, the default is normal.
     */
    @JvmName("mweocylmjibtisyu")
    public fun priority(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Priority>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value Priority with which the job should be processed. Higher priority jobs are processed before lower priority jobs. If not set, the default is normal.
     */
    @JvmName("btnbgqmnskvyfcxw")
    public fun priority(`value`: Priority) {
        val toBeMapped = Either.ofRight<String, Priority>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The name of the resource group within the Azure subscription.
     */
    @JvmName("ybqsqmgxpbwgaodr")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The Transform name.
     */
    @JvmName("tgwbffnhkjabemqs")
    public suspend fun transformName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transformName = mapped
    }

    internal fun build(): JobArgs = JobArgs(
        accountName = accountName,
        correlationData = correlationData,
        description = description,
        input = input,
        jobName = jobName,
        outputs = outputs,
        priority = priority,
        resourceGroupName = resourceGroupName,
        transformName = transformName,
    )
}
