@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin

import com.pulumi.azurenative.media.MediaFunctions.getAccountFilterPlain
import com.pulumi.azurenative.media.MediaFunctions.getAssetEncryptionKeyPlain
import com.pulumi.azurenative.media.MediaFunctions.getAssetFilterPlain
import com.pulumi.azurenative.media.MediaFunctions.getAssetPlain
import com.pulumi.azurenative.media.MediaFunctions.getContentKeyPolicyPlain
import com.pulumi.azurenative.media.MediaFunctions.getContentKeyPolicyPropertiesWithSecretsPlain
import com.pulumi.azurenative.media.MediaFunctions.getJobPlain
import com.pulumi.azurenative.media.MediaFunctions.getLiveEventPlain
import com.pulumi.azurenative.media.MediaFunctions.getLiveEventStatusPlain
import com.pulumi.azurenative.media.MediaFunctions.getLiveEventStreamEventsPlain
import com.pulumi.azurenative.media.MediaFunctions.getLiveEventTrackIngestHeartbeatsPlain
import com.pulumi.azurenative.media.MediaFunctions.getLiveOutputPlain
import com.pulumi.azurenative.media.MediaFunctions.getMediaGraphPlain
import com.pulumi.azurenative.media.MediaFunctions.getMediaServicePlain
import com.pulumi.azurenative.media.MediaFunctions.getPrivateEndpointConnectionPlain
import com.pulumi.azurenative.media.MediaFunctions.getStreamingEndpointPlain
import com.pulumi.azurenative.media.MediaFunctions.getStreamingLocatorPlain
import com.pulumi.azurenative.media.MediaFunctions.getStreamingPolicyPlain
import com.pulumi.azurenative.media.MediaFunctions.getTrackPlain
import com.pulumi.azurenative.media.MediaFunctions.getTransformPlain
import com.pulumi.azurenative.media.MediaFunctions.listAssetContainerSasPlain
import com.pulumi.azurenative.media.MediaFunctions.listAssetStreamingLocatorsPlain
import com.pulumi.azurenative.media.MediaFunctions.listMediaServiceEdgePoliciesPlain
import com.pulumi.azurenative.media.MediaFunctions.listMediaServiceKeysPlain
import com.pulumi.azurenative.media.MediaFunctions.listStreamingLocatorContentKeysPlain
import com.pulumi.azurenative.media.MediaFunctions.listStreamingLocatorPathsPlain
import com.pulumi.azurenative.media.kotlin.enums.AssetContainerPermission
import com.pulumi.azurenative.media.kotlin.inputs.GetAccountFilterPlainArgs
import com.pulumi.azurenative.media.kotlin.inputs.GetAccountFilterPlainArgsBuilder
import com.pulumi.azurenative.media.kotlin.inputs.GetAssetEncryptionKeyPlainArgs
import com.pulumi.azurenative.media.kotlin.inputs.GetAssetEncryptionKeyPlainArgsBuilder
import com.pulumi.azurenative.media.kotlin.inputs.GetAssetFilterPlainArgs
import com.pulumi.azurenative.media.kotlin.inputs.GetAssetFilterPlainArgsBuilder
import com.pulumi.azurenative.media.kotlin.inputs.GetAssetPlainArgs
import com.pulumi.azurenative.media.kotlin.inputs.GetAssetPlainArgsBuilder
import com.pulumi.azurenative.media.kotlin.inputs.GetContentKeyPolicyPlainArgs
import com.pulumi.azurenative.media.kotlin.inputs.GetContentKeyPolicyPlainArgsBuilder
import com.pulumi.azurenative.media.kotlin.inputs.GetContentKeyPolicyPropertiesWithSecretsPlainArgs
import com.pulumi.azurenative.media.kotlin.inputs.GetContentKeyPolicyPropertiesWithSecretsPlainArgsBuilder
import com.pulumi.azurenative.media.kotlin.inputs.GetJobPlainArgs
import com.pulumi.azurenative.media.kotlin.inputs.GetJobPlainArgsBuilder
import com.pulumi.azurenative.media.kotlin.inputs.GetLiveEventPlainArgs
import com.pulumi.azurenative.media.kotlin.inputs.GetLiveEventPlainArgsBuilder
import com.pulumi.azurenative.media.kotlin.inputs.GetLiveEventStatusPlainArgs
import com.pulumi.azurenative.media.kotlin.inputs.GetLiveEventStatusPlainArgsBuilder
import com.pulumi.azurenative.media.kotlin.inputs.GetLiveEventStreamEventsPlainArgs
import com.pulumi.azurenative.media.kotlin.inputs.GetLiveEventStreamEventsPlainArgsBuilder
import com.pulumi.azurenative.media.kotlin.inputs.GetLiveEventTrackIngestHeartbeatsPlainArgs
import com.pulumi.azurenative.media.kotlin.inputs.GetLiveEventTrackIngestHeartbeatsPlainArgsBuilder
import com.pulumi.azurenative.media.kotlin.inputs.GetLiveOutputPlainArgs
import com.pulumi.azurenative.media.kotlin.inputs.GetLiveOutputPlainArgsBuilder
import com.pulumi.azurenative.media.kotlin.inputs.GetMediaGraphPlainArgs
import com.pulumi.azurenative.media.kotlin.inputs.GetMediaGraphPlainArgsBuilder
import com.pulumi.azurenative.media.kotlin.inputs.GetMediaServicePlainArgs
import com.pulumi.azurenative.media.kotlin.inputs.GetMediaServicePlainArgsBuilder
import com.pulumi.azurenative.media.kotlin.inputs.GetPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.media.kotlin.inputs.GetPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.media.kotlin.inputs.GetStreamingEndpointPlainArgs
import com.pulumi.azurenative.media.kotlin.inputs.GetStreamingEndpointPlainArgsBuilder
import com.pulumi.azurenative.media.kotlin.inputs.GetStreamingLocatorPlainArgs
import com.pulumi.azurenative.media.kotlin.inputs.GetStreamingLocatorPlainArgsBuilder
import com.pulumi.azurenative.media.kotlin.inputs.GetStreamingPolicyPlainArgs
import com.pulumi.azurenative.media.kotlin.inputs.GetStreamingPolicyPlainArgsBuilder
import com.pulumi.azurenative.media.kotlin.inputs.GetTrackPlainArgs
import com.pulumi.azurenative.media.kotlin.inputs.GetTrackPlainArgsBuilder
import com.pulumi.azurenative.media.kotlin.inputs.GetTransformPlainArgs
import com.pulumi.azurenative.media.kotlin.inputs.GetTransformPlainArgsBuilder
import com.pulumi.azurenative.media.kotlin.inputs.ListAssetContainerSasPlainArgs
import com.pulumi.azurenative.media.kotlin.inputs.ListAssetContainerSasPlainArgsBuilder
import com.pulumi.azurenative.media.kotlin.inputs.ListAssetStreamingLocatorsPlainArgs
import com.pulumi.azurenative.media.kotlin.inputs.ListAssetStreamingLocatorsPlainArgsBuilder
import com.pulumi.azurenative.media.kotlin.inputs.ListMediaServiceEdgePoliciesPlainArgs
import com.pulumi.azurenative.media.kotlin.inputs.ListMediaServiceEdgePoliciesPlainArgsBuilder
import com.pulumi.azurenative.media.kotlin.inputs.ListMediaServiceKeysPlainArgs
import com.pulumi.azurenative.media.kotlin.inputs.ListMediaServiceKeysPlainArgsBuilder
import com.pulumi.azurenative.media.kotlin.inputs.ListStreamingLocatorContentKeysPlainArgs
import com.pulumi.azurenative.media.kotlin.inputs.ListStreamingLocatorContentKeysPlainArgsBuilder
import com.pulumi.azurenative.media.kotlin.inputs.ListStreamingLocatorPathsPlainArgs
import com.pulumi.azurenative.media.kotlin.inputs.ListStreamingLocatorPathsPlainArgsBuilder
import com.pulumi.azurenative.media.kotlin.outputs.GetAccountFilterResult
import com.pulumi.azurenative.media.kotlin.outputs.GetAssetEncryptionKeyResult
import com.pulumi.azurenative.media.kotlin.outputs.GetAssetFilterResult
import com.pulumi.azurenative.media.kotlin.outputs.GetAssetResult
import com.pulumi.azurenative.media.kotlin.outputs.GetContentKeyPolicyPropertiesWithSecretsResult
import com.pulumi.azurenative.media.kotlin.outputs.GetContentKeyPolicyResult
import com.pulumi.azurenative.media.kotlin.outputs.GetJobResult
import com.pulumi.azurenative.media.kotlin.outputs.GetLiveEventResult
import com.pulumi.azurenative.media.kotlin.outputs.GetLiveEventStatusResult
import com.pulumi.azurenative.media.kotlin.outputs.GetLiveEventStreamEventsResult
import com.pulumi.azurenative.media.kotlin.outputs.GetLiveEventTrackIngestHeartbeatsResult
import com.pulumi.azurenative.media.kotlin.outputs.GetLiveOutputResult
import com.pulumi.azurenative.media.kotlin.outputs.GetMediaGraphResult
import com.pulumi.azurenative.media.kotlin.outputs.GetMediaServiceResult
import com.pulumi.azurenative.media.kotlin.outputs.GetPrivateEndpointConnectionResult
import com.pulumi.azurenative.media.kotlin.outputs.GetStreamingEndpointResult
import com.pulumi.azurenative.media.kotlin.outputs.GetStreamingLocatorResult
import com.pulumi.azurenative.media.kotlin.outputs.GetStreamingPolicyResult
import com.pulumi.azurenative.media.kotlin.outputs.GetTrackResult
import com.pulumi.azurenative.media.kotlin.outputs.GetTransformResult
import com.pulumi.azurenative.media.kotlin.outputs.ListAssetContainerSasResult
import com.pulumi.azurenative.media.kotlin.outputs.ListAssetStreamingLocatorsResult
import com.pulumi.azurenative.media.kotlin.outputs.ListMediaServiceEdgePoliciesResult
import com.pulumi.azurenative.media.kotlin.outputs.ListMediaServiceKeysResult
import com.pulumi.azurenative.media.kotlin.outputs.ListStreamingLocatorContentKeysResult
import com.pulumi.azurenative.media.kotlin.outputs.ListStreamingLocatorPathsResult
import com.pulumi.core.Either
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.media.kotlin.outputs.GetAccountFilterResult.Companion.toKotlin as getAccountFilterResultToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.GetAssetEncryptionKeyResult.Companion.toKotlin as getAssetEncryptionKeyResultToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.GetAssetFilterResult.Companion.toKotlin as getAssetFilterResultToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.GetAssetResult.Companion.toKotlin as getAssetResultToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.GetContentKeyPolicyPropertiesWithSecretsResult.Companion.toKotlin as getContentKeyPolicyPropertiesWithSecretsResultToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.GetContentKeyPolicyResult.Companion.toKotlin as getContentKeyPolicyResultToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.GetJobResult.Companion.toKotlin as getJobResultToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.GetLiveEventResult.Companion.toKotlin as getLiveEventResultToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.GetLiveEventStatusResult.Companion.toKotlin as getLiveEventStatusResultToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.GetLiveEventStreamEventsResult.Companion.toKotlin as getLiveEventStreamEventsResultToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.GetLiveEventTrackIngestHeartbeatsResult.Companion.toKotlin as getLiveEventTrackIngestHeartbeatsResultToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.GetLiveOutputResult.Companion.toKotlin as getLiveOutputResultToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.GetMediaGraphResult.Companion.toKotlin as getMediaGraphResultToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.GetMediaServiceResult.Companion.toKotlin as getMediaServiceResultToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.GetPrivateEndpointConnectionResult.Companion.toKotlin as getPrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.GetStreamingEndpointResult.Companion.toKotlin as getStreamingEndpointResultToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.GetStreamingLocatorResult.Companion.toKotlin as getStreamingLocatorResultToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.GetStreamingPolicyResult.Companion.toKotlin as getStreamingPolicyResultToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.GetTrackResult.Companion.toKotlin as getTrackResultToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.GetTransformResult.Companion.toKotlin as getTransformResultToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.ListAssetContainerSasResult.Companion.toKotlin as listAssetContainerSasResultToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.ListAssetStreamingLocatorsResult.Companion.toKotlin as listAssetStreamingLocatorsResultToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.ListMediaServiceEdgePoliciesResult.Companion.toKotlin as listMediaServiceEdgePoliciesResultToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.ListMediaServiceKeysResult.Companion.toKotlin as listMediaServiceKeysResultToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.ListStreamingLocatorContentKeysResult.Companion.toKotlin as listStreamingLocatorContentKeysResultToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.ListStreamingLocatorPathsResult.Companion.toKotlin as listStreamingLocatorPathsResultToKotlin

public object MediaFunctions {
    /**
     * Get the details of an Account Filter in the Media Services account.
     * Azure REST API version: 2023-01-01.
     * @param argument null
     * @return An Account Filter.
     */
    public suspend fun getAccountFilter(argument: GetAccountFilterPlainArgs): GetAccountFilterResult =
        getAccountFilterResultToKotlin(getAccountFilterPlain(argument.toJava()).await())

    /**
     * @see [getAccountFilter].
     * @param accountName The Media Services account name.
     * @param filterName The Account Filter name
     * @param resourceGroupName The name of the resource group within the Azure subscription.
     * @return An Account Filter.
     */
    public suspend fun getAccountFilter(
        accountName: String,
        filterName: String,
        resourceGroupName: String,
    ): GetAccountFilterResult {
        val argument = GetAccountFilterPlainArgs(
            accountName = accountName,
            filterName = filterName,
            resourceGroupName = resourceGroupName,
        )
        return getAccountFilterResultToKotlin(getAccountFilterPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccountFilter].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;media&#46;kotlin&#46;inputs&#46;GetAccountFilterPlainArgs].
     * @return An Account Filter.
     */
    public suspend fun getAccountFilter(argument: suspend GetAccountFilterPlainArgsBuilder.() -> Unit): GetAccountFilterResult {
        val builder = GetAccountFilterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAccountFilterResultToKotlin(getAccountFilterPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the details of an Asset in the Media Services account
     * Azure REST API version: 2023-01-01.
     * @param argument null
     * @return An Asset.
     */
    public suspend fun getAsset(argument: GetAssetPlainArgs): GetAssetResult =
        getAssetResultToKotlin(getAssetPlain(argument.toJava()).await())

    /**
     * @see [getAsset].
     * @param accountName The Media Services account name.
     * @param assetName The Asset name.
     * @param resourceGroupName The name of the resource group within the Azure subscription.
     * @return An Asset.
     */
    public suspend fun getAsset(
        accountName: String,
        assetName: String,
        resourceGroupName: String,
    ): GetAssetResult {
        val argument = GetAssetPlainArgs(
            accountName = accountName,
            assetName = assetName,
            resourceGroupName = resourceGroupName,
        )
        return getAssetResultToKotlin(getAssetPlain(argument.toJava()).await())
    }

    /**
     * @see [getAsset].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;media&#46;kotlin&#46;inputs&#46;GetAssetPlainArgs].
     * @return An Asset.
     */
    public suspend fun getAsset(argument: suspend GetAssetPlainArgsBuilder.() -> Unit): GetAssetResult {
        val builder = GetAssetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAssetResultToKotlin(getAssetPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the Asset storage encryption keys used to decrypt content created by version 2 of the Media Services API
     * Azure REST API version: 2023-01-01.
     * @param argument null
     * @return Data needed to decrypt asset files encrypted with legacy storage encryption.
     */
    public suspend fun getAssetEncryptionKey(argument: GetAssetEncryptionKeyPlainArgs): GetAssetEncryptionKeyResult =
        getAssetEncryptionKeyResultToKotlin(getAssetEncryptionKeyPlain(argument.toJava()).await())

    /**
     * @see [getAssetEncryptionKey].
     * @param accountName The Media Services account name.
     * @param assetName The Asset name.
     * @param resourceGroupName The name of the resource group within the Azure subscription.
     * @return Data needed to decrypt asset files encrypted with legacy storage encryption.
     */
    public suspend fun getAssetEncryptionKey(
        accountName: String,
        assetName: String,
        resourceGroupName: String,
    ): GetAssetEncryptionKeyResult {
        val argument = GetAssetEncryptionKeyPlainArgs(
            accountName = accountName,
            assetName = assetName,
            resourceGroupName = resourceGroupName,
        )
        return getAssetEncryptionKeyResultToKotlin(getAssetEncryptionKeyPlain(argument.toJava()).await())
    }

    /**
     * @see [getAssetEncryptionKey].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;media&#46;kotlin&#46;inputs&#46;GetAssetEncryptionKeyPlainArgs].
     * @return Data needed to decrypt asset files encrypted with legacy storage encryption.
     */
    public suspend fun getAssetEncryptionKey(argument: suspend GetAssetEncryptionKeyPlainArgsBuilder.() -> Unit): GetAssetEncryptionKeyResult {
        val builder = GetAssetEncryptionKeyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAssetEncryptionKeyResultToKotlin(getAssetEncryptionKeyPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the details of an Asset Filter associated with the specified Asset.
     * Azure REST API version: 2023-01-01.
     * @param argument null
     * @return An Asset Filter.
     */
    public suspend fun getAssetFilter(argument: GetAssetFilterPlainArgs): GetAssetFilterResult =
        getAssetFilterResultToKotlin(getAssetFilterPlain(argument.toJava()).await())

    /**
     * @see [getAssetFilter].
     * @param accountName The Media Services account name.
     * @param assetName The Asset name.
     * @param filterName The Asset Filter name
     * @param resourceGroupName The name of the resource group within the Azure subscription.
     * @return An Asset Filter.
     */
    public suspend fun getAssetFilter(
        accountName: String,
        assetName: String,
        filterName: String,
        resourceGroupName: String,
    ): GetAssetFilterResult {
        val argument = GetAssetFilterPlainArgs(
            accountName = accountName,
            assetName = assetName,
            filterName = filterName,
            resourceGroupName = resourceGroupName,
        )
        return getAssetFilterResultToKotlin(getAssetFilterPlain(argument.toJava()).await())
    }

    /**
     * @see [getAssetFilter].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;media&#46;kotlin&#46;inputs&#46;GetAssetFilterPlainArgs].
     * @return An Asset Filter.
     */
    public suspend fun getAssetFilter(argument: suspend GetAssetFilterPlainArgsBuilder.() -> Unit): GetAssetFilterResult {
        val builder = GetAssetFilterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAssetFilterResultToKotlin(getAssetFilterPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the details of a Content Key Policy in the Media Services account
     * Azure REST API version: 2023-01-01.
     * @param argument null
     * @return A Content Key Policy resource.
     */
    public suspend fun getContentKeyPolicy(argument: GetContentKeyPolicyPlainArgs): GetContentKeyPolicyResult =
        getContentKeyPolicyResultToKotlin(getContentKeyPolicyPlain(argument.toJava()).await())

    /**
     * @see [getContentKeyPolicy].
     * @param accountName The Media Services account name.
     * @param contentKeyPolicyName The Content Key Policy name.
     * @param resourceGroupName The name of the resource group within the Azure subscription.
     * @return A Content Key Policy resource.
     */
    public suspend fun getContentKeyPolicy(
        accountName: String,
        contentKeyPolicyName: String,
        resourceGroupName: String,
    ): GetContentKeyPolicyResult {
        val argument = GetContentKeyPolicyPlainArgs(
            accountName = accountName,
            contentKeyPolicyName = contentKeyPolicyName,
            resourceGroupName = resourceGroupName,
        )
        return getContentKeyPolicyResultToKotlin(getContentKeyPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getContentKeyPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;media&#46;kotlin&#46;inputs&#46;GetContentKeyPolicyPlainArgs].
     * @return A Content Key Policy resource.
     */
    public suspend fun getContentKeyPolicy(argument: suspend GetContentKeyPolicyPlainArgsBuilder.() -> Unit): GetContentKeyPolicyResult {
        val builder = GetContentKeyPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getContentKeyPolicyResultToKotlin(getContentKeyPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a Content Key Policy including secret values
     * Azure REST API version: 2023-01-01.
     * @param argument null
     * @return The properties of the Content Key Policy.
     */
    public suspend fun getContentKeyPolicyPropertiesWithSecrets(argument: GetContentKeyPolicyPropertiesWithSecretsPlainArgs): GetContentKeyPolicyPropertiesWithSecretsResult =
        getContentKeyPolicyPropertiesWithSecretsResultToKotlin(getContentKeyPolicyPropertiesWithSecretsPlain(argument.toJava()).await())

    /**
     * @see [getContentKeyPolicyPropertiesWithSecrets].
     * @param accountName The Media Services account name.
     * @param contentKeyPolicyName The Content Key Policy name.
     * @param resourceGroupName The name of the resource group within the Azure subscription.
     * @return The properties of the Content Key Policy.
     */
    public suspend fun getContentKeyPolicyPropertiesWithSecrets(
        accountName: String,
        contentKeyPolicyName: String,
        resourceGroupName: String,
    ): GetContentKeyPolicyPropertiesWithSecretsResult {
        val argument = GetContentKeyPolicyPropertiesWithSecretsPlainArgs(
            accountName = accountName,
            contentKeyPolicyName = contentKeyPolicyName,
            resourceGroupName = resourceGroupName,
        )
        return getContentKeyPolicyPropertiesWithSecretsResultToKotlin(getContentKeyPolicyPropertiesWithSecretsPlain(argument.toJava()).await())
    }

    /**
     * @see [getContentKeyPolicyPropertiesWithSecrets].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;media&#46;kotlin&#46;inputs&#46;GetContentKeyPolicyPropertiesWithSecretsPlainArgs].
     * @return The properties of the Content Key Policy.
     */
    public suspend fun getContentKeyPolicyPropertiesWithSecrets(argument: suspend GetContentKeyPolicyPropertiesWithSecretsPlainArgsBuilder.() -> Unit): GetContentKeyPolicyPropertiesWithSecretsResult {
        val builder = GetContentKeyPolicyPropertiesWithSecretsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getContentKeyPolicyPropertiesWithSecretsResultToKotlin(getContentKeyPolicyPropertiesWithSecretsPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a Job.
     * Azure REST API version: 2022-07-01.
     * @param argument null
     * @return A Job resource type. The progress and state can be obtained by polling a Job or subscribing to events using EventGrid.
     */
    public suspend fun getJob(argument: GetJobPlainArgs): GetJobResult =
        getJobResultToKotlin(getJobPlain(argument.toJava()).await())

    /**
     * @see [getJob].
     * @param accountName The Media Services account name.
     * @param jobName The Job name.
     * @param resourceGroupName The name of the resource group within the Azure subscription.
     * @param transformName The Transform name.
     * @return A Job resource type. The progress and state can be obtained by polling a Job or subscribing to events using EventGrid.
     */
    public suspend fun getJob(
        accountName: String,
        jobName: String,
        resourceGroupName: String,
        transformName: String,
    ): GetJobResult {
        val argument = GetJobPlainArgs(
            accountName = accountName,
            jobName = jobName,
            resourceGroupName = resourceGroupName,
            transformName = transformName,
        )
        return getJobResultToKotlin(getJobPlain(argument.toJava()).await())
    }

    /**
     * @see [getJob].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;media&#46;kotlin&#46;inputs&#46;GetJobPlainArgs].
     * @return A Job resource type. The progress and state can be obtained by polling a Job or subscribing to events using EventGrid.
     */
    public suspend fun getJob(argument: suspend GetJobPlainArgsBuilder.() -> Unit): GetJobResult {
        val builder = GetJobPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getJobResultToKotlin(getJobPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets properties of a live event.
     * Azure REST API version: 2022-11-01.
     * Other available API versions: 2018-06-01-preview, 2019-05-01-preview.
     * @param argument null
     * @return The live event.
     */
    public suspend fun getLiveEvent(argument: GetLiveEventPlainArgs): GetLiveEventResult =
        getLiveEventResultToKotlin(getLiveEventPlain(argument.toJava()).await())

    /**
     * @see [getLiveEvent].
     * @param accountName The Media Services account name.
     * @param liveEventName The name of the live event, maximum length is 32.
     * @param resourceGroupName The name of the resource group within the Azure subscription.
     * @return The live event.
     */
    public suspend fun getLiveEvent(
        accountName: String,
        liveEventName: String,
        resourceGroupName: String,
    ): GetLiveEventResult {
        val argument = GetLiveEventPlainArgs(
            accountName = accountName,
            liveEventName = liveEventName,
            resourceGroupName = resourceGroupName,
        )
        return getLiveEventResultToKotlin(getLiveEventPlain(argument.toJava()).await())
    }

    /**
     * @see [getLiveEvent].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;media&#46;kotlin&#46;inputs&#46;GetLiveEventPlainArgs].
     * @return The live event.
     */
    public suspend fun getLiveEvent(argument: suspend GetLiveEventPlainArgsBuilder.() -> Unit): GetLiveEventResult {
        val builder = GetLiveEventPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLiveEventResultToKotlin(getLiveEventPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets status telemetry of a live event.
     * Azure REST API version: 2022-11-01.
     * @param argument null
     * @return Get live event status result.
     */
    public suspend fun getLiveEventStatus(argument: GetLiveEventStatusPlainArgs): GetLiveEventStatusResult =
        getLiveEventStatusResultToKotlin(getLiveEventStatusPlain(argument.toJava()).await())

    /**
     * @see [getLiveEventStatus].
     * @param accountName The Media Services account name.
     * @param liveEventName The name of the live event, maximum length is 32.
     * @param resourceGroupName The name of the resource group within the Azure subscription.
     * @return Get live event status result.
     */
    public suspend fun getLiveEventStatus(
        accountName: String,
        liveEventName: String,
        resourceGroupName: String,
    ): GetLiveEventStatusResult {
        val argument = GetLiveEventStatusPlainArgs(
            accountName = accountName,
            liveEventName = liveEventName,
            resourceGroupName = resourceGroupName,
        )
        return getLiveEventStatusResultToKotlin(getLiveEventStatusPlain(argument.toJava()).await())
    }

    /**
     * @see [getLiveEventStatus].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;media&#46;kotlin&#46;inputs&#46;GetLiveEventStatusPlainArgs].
     * @return Get live event status result.
     */
    public suspend fun getLiveEventStatus(argument: suspend GetLiveEventStatusPlainArgsBuilder.() -> Unit): GetLiveEventStatusResult {
        val builder = GetLiveEventStatusPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLiveEventStatusResultToKotlin(getLiveEventStatusPlain(builtArgument.toJava()).await())
    }

    /**
     * Get stream events telemetry of a live event.
     * Azure REST API version: 2022-11-01.
     * @param argument null
     * @return Get live event stream events result.
     */
    public suspend fun getLiveEventStreamEvents(argument: GetLiveEventStreamEventsPlainArgs): GetLiveEventStreamEventsResult =
        getLiveEventStreamEventsResultToKotlin(getLiveEventStreamEventsPlain(argument.toJava()).await())

    /**
     * @see [getLiveEventStreamEvents].
     * @param accountName The Media Services account name.
     * @param liveEventName The name of the live event, maximum length is 32.
     * @param resourceGroupName The name of the resource group within the Azure subscription.
     * @return Get live event stream events result.
     */
    public suspend fun getLiveEventStreamEvents(
        accountName: String,
        liveEventName: String,
        resourceGroupName: String,
    ): GetLiveEventStreamEventsResult {
        val argument = GetLiveEventStreamEventsPlainArgs(
            accountName = accountName,
            liveEventName = liveEventName,
            resourceGroupName = resourceGroupName,
        )
        return getLiveEventStreamEventsResultToKotlin(getLiveEventStreamEventsPlain(argument.toJava()).await())
    }

    /**
     * @see [getLiveEventStreamEvents].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;media&#46;kotlin&#46;inputs&#46;GetLiveEventStreamEventsPlainArgs].
     * @return Get live event stream events result.
     */
    public suspend fun getLiveEventStreamEvents(argument: suspend GetLiveEventStreamEventsPlainArgsBuilder.() -> Unit): GetLiveEventStreamEventsResult {
        val builder = GetLiveEventStreamEventsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLiveEventStreamEventsResultToKotlin(getLiveEventStreamEventsPlain(builtArgument.toJava()).await())
    }

    /**
     * Get track ingest heartbeat events telemetry of a live event.
     * Azure REST API version: 2022-11-01.
     * @param argument null
     * @return Get live event track ingest heart beats result.
     */
    public suspend fun getLiveEventTrackIngestHeartbeats(argument: GetLiveEventTrackIngestHeartbeatsPlainArgs): GetLiveEventTrackIngestHeartbeatsResult =
        getLiveEventTrackIngestHeartbeatsResultToKotlin(getLiveEventTrackIngestHeartbeatsPlain(argument.toJava()).await())

    /**
     * @see [getLiveEventTrackIngestHeartbeats].
     * @param accountName The Media Services account name.
     * @param liveEventName The name of the live event, maximum length is 32.
     * @param resourceGroupName The name of the resource group within the Azure subscription.
     * @return Get live event track ingest heart beats result.
     */
    public suspend fun getLiveEventTrackIngestHeartbeats(
        accountName: String,
        liveEventName: String,
        resourceGroupName: String,
    ): GetLiveEventTrackIngestHeartbeatsResult {
        val argument = GetLiveEventTrackIngestHeartbeatsPlainArgs(
            accountName = accountName,
            liveEventName = liveEventName,
            resourceGroupName = resourceGroupName,
        )
        return getLiveEventTrackIngestHeartbeatsResultToKotlin(getLiveEventTrackIngestHeartbeatsPlain(argument.toJava()).await())
    }

    /**
     * @see [getLiveEventTrackIngestHeartbeats].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;media&#46;kotlin&#46;inputs&#46;GetLiveEventTrackIngestHeartbeatsPlainArgs].
     * @return Get live event track ingest heart beats result.
     */
    public suspend fun getLiveEventTrackIngestHeartbeats(argument: suspend GetLiveEventTrackIngestHeartbeatsPlainArgsBuilder.() -> Unit): GetLiveEventTrackIngestHeartbeatsResult {
        val builder = GetLiveEventTrackIngestHeartbeatsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLiveEventTrackIngestHeartbeatsResultToKotlin(getLiveEventTrackIngestHeartbeatsPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a live output.
     * Azure REST API version: 2022-11-01.
     * @param argument null
     * @return The Live Output.
     */
    public suspend fun getLiveOutput(argument: GetLiveOutputPlainArgs): GetLiveOutputResult =
        getLiveOutputResultToKotlin(getLiveOutputPlain(argument.toJava()).await())

    /**
     * @see [getLiveOutput].
     * @param accountName The Media Services account name.
     * @param liveEventName The name of the live event, maximum length is 32.
     * @param liveOutputName The name of the live output.
     * @param resourceGroupName The name of the resource group within the Azure subscription.
     * @return The Live Output.
     */
    public suspend fun getLiveOutput(
        accountName: String,
        liveEventName: String,
        liveOutputName: String,
        resourceGroupName: String,
    ): GetLiveOutputResult {
        val argument = GetLiveOutputPlainArgs(
            accountName = accountName,
            liveEventName = liveEventName,
            liveOutputName = liveOutputName,
            resourceGroupName = resourceGroupName,
        )
        return getLiveOutputResultToKotlin(getLiveOutputPlain(argument.toJava()).await())
    }

    /**
     * @see [getLiveOutput].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;media&#46;kotlin&#46;inputs&#46;GetLiveOutputPlainArgs].
     * @return The Live Output.
     */
    public suspend fun getLiveOutput(argument: suspend GetLiveOutputPlainArgsBuilder.() -> Unit): GetLiveOutputResult {
        val builder = GetLiveOutputPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLiveOutputResultToKotlin(getLiveOutputPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the details of a Media Graph in the Media Services account.
     * Azure REST API version: 2020-02-01-preview.
     * @param argument null
     * @return The Media Graph.
     */
    public suspend fun getMediaGraph(argument: GetMediaGraphPlainArgs): GetMediaGraphResult =
        getMediaGraphResultToKotlin(getMediaGraphPlain(argument.toJava()).await())

    /**
     * @see [getMediaGraph].
     * @param accountName The Media Services account name.
     * @param mediaGraphName The Media Graph name.
     * @param resourceGroupName The name of the resource group within the Azure subscription.
     * @return The Media Graph.
     */
    public suspend fun getMediaGraph(
        accountName: String,
        mediaGraphName: String,
        resourceGroupName: String,
    ): GetMediaGraphResult {
        val argument = GetMediaGraphPlainArgs(
            accountName = accountName,
            mediaGraphName = mediaGraphName,
            resourceGroupName = resourceGroupName,
        )
        return getMediaGraphResultToKotlin(getMediaGraphPlain(argument.toJava()).await())
    }

    /**
     * @see [getMediaGraph].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;media&#46;kotlin&#46;inputs&#46;GetMediaGraphPlainArgs].
     * @return The Media Graph.
     */
    public suspend fun getMediaGraph(argument: suspend GetMediaGraphPlainArgsBuilder.() -> Unit): GetMediaGraphResult {
        val builder = GetMediaGraphPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMediaGraphResultToKotlin(getMediaGraphPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the details of a Media Services account
     * Azure REST API version: 2023-01-01.
     * Other available API versions: 2015-10-01.
     * @param argument null
     * @return A Media Services account.
     */
    public suspend fun getMediaService(argument: GetMediaServicePlainArgs): GetMediaServiceResult =
        getMediaServiceResultToKotlin(getMediaServicePlain(argument.toJava()).await())

    /**
     * @see [getMediaService].
     * @param accountName The Media Services account name.
     * @param resourceGroupName The name of the resource group within the Azure subscription.
     * @return A Media Services account.
     */
    public suspend fun getMediaService(accountName: String, resourceGroupName: String): GetMediaServiceResult {
        val argument = GetMediaServicePlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
        )
        return getMediaServiceResultToKotlin(getMediaServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getMediaService].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;media&#46;kotlin&#46;inputs&#46;GetMediaServicePlainArgs].
     * @return A Media Services account.
     */
    public suspend fun getMediaService(argument: suspend GetMediaServicePlainArgsBuilder.() -> Unit): GetMediaServiceResult {
        val builder = GetMediaServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMediaServiceResultToKotlin(getMediaServicePlain(builtArgument.toJava()).await())
    }

    /**
     * Get the details of a private endpoint connection.
     * Azure REST API version: 2023-01-01.
     * @param argument null
     * @return The Private Endpoint Connection resource.
     */
    public suspend fun getPrivateEndpointConnection(argument: GetPrivateEndpointConnectionPlainArgs): GetPrivateEndpointConnectionResult =
        getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnection].
     * @param accountName The Media Services account name.
     * @param name
     * @param resourceGroupName The name of the resource group within the Azure subscription.
     * @return The Private Endpoint Connection resource.
     */
    public suspend fun getPrivateEndpointConnection(
        accountName: String,
        name: String,
        resourceGroupName: String,
    ): GetPrivateEndpointConnectionResult {
        val argument = GetPrivateEndpointConnectionPlainArgs(
            accountName = accountName,
            name = name,
            resourceGroupName = resourceGroupName,
        )
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;media&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionPlainArgs].
     * @return The Private Endpoint Connection resource.
     */
    public suspend fun getPrivateEndpointConnection(argument: suspend GetPrivateEndpointConnectionPlainArgsBuilder.() -> Unit): GetPrivateEndpointConnectionResult {
        val builder = GetPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a streaming endpoint.
     * Azure REST API version: 2022-11-01.
     * Other available API versions: 2018-06-01-preview.
     * @param argument null
     * @return The streaming endpoint.
     */
    public suspend fun getStreamingEndpoint(argument: GetStreamingEndpointPlainArgs): GetStreamingEndpointResult =
        getStreamingEndpointResultToKotlin(getStreamingEndpointPlain(argument.toJava()).await())

    /**
     * @see [getStreamingEndpoint].
     * @param accountName The Media Services account name.
     * @param resourceGroupName The name of the resource group within the Azure subscription.
     * @param streamingEndpointName The name of the streaming endpoint, maximum length is 24.
     * @return The streaming endpoint.
     */
    public suspend fun getStreamingEndpoint(
        accountName: String,
        resourceGroupName: String,
        streamingEndpointName: String,
    ): GetStreamingEndpointResult {
        val argument = GetStreamingEndpointPlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
            streamingEndpointName = streamingEndpointName,
        )
        return getStreamingEndpointResultToKotlin(getStreamingEndpointPlain(argument.toJava()).await())
    }

    /**
     * @see [getStreamingEndpoint].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;media&#46;kotlin&#46;inputs&#46;GetStreamingEndpointPlainArgs].
     * @return The streaming endpoint.
     */
    public suspend fun getStreamingEndpoint(argument: suspend GetStreamingEndpointPlainArgsBuilder.() -> Unit): GetStreamingEndpointResult {
        val builder = GetStreamingEndpointPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getStreamingEndpointResultToKotlin(getStreamingEndpointPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the details of a Streaming Locator in the Media Services account
     * Azure REST API version: 2023-01-01.
     * Other available API versions: 2018-03-30-preview.
     * @param argument null
     * @return A Streaming Locator resource
     */
    public suspend fun getStreamingLocator(argument: GetStreamingLocatorPlainArgs): GetStreamingLocatorResult =
        getStreamingLocatorResultToKotlin(getStreamingLocatorPlain(argument.toJava()).await())

    /**
     * @see [getStreamingLocator].
     * @param accountName The Media Services account name.
     * @param resourceGroupName The name of the resource group within the Azure subscription.
     * @param streamingLocatorName The Streaming Locator name.
     * @return A Streaming Locator resource
     */
    public suspend fun getStreamingLocator(
        accountName: String,
        resourceGroupName: String,
        streamingLocatorName: String,
    ): GetStreamingLocatorResult {
        val argument = GetStreamingLocatorPlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
            streamingLocatorName = streamingLocatorName,
        )
        return getStreamingLocatorResultToKotlin(getStreamingLocatorPlain(argument.toJava()).await())
    }

    /**
     * @see [getStreamingLocator].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;media&#46;kotlin&#46;inputs&#46;GetStreamingLocatorPlainArgs].
     * @return A Streaming Locator resource
     */
    public suspend fun getStreamingLocator(argument: suspend GetStreamingLocatorPlainArgsBuilder.() -> Unit): GetStreamingLocatorResult {
        val builder = GetStreamingLocatorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getStreamingLocatorResultToKotlin(getStreamingLocatorPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the details of a Streaming Policy in the Media Services account
     * Azure REST API version: 2023-01-01.
     * @param argument null
     * @return A Streaming Policy resource
     */
    public suspend fun getStreamingPolicy(argument: GetStreamingPolicyPlainArgs): GetStreamingPolicyResult =
        getStreamingPolicyResultToKotlin(getStreamingPolicyPlain(argument.toJava()).await())

    /**
     * @see [getStreamingPolicy].
     * @param accountName The Media Services account name.
     * @param resourceGroupName The name of the resource group within the Azure subscription.
     * @param streamingPolicyName The Streaming Policy name.
     * @return A Streaming Policy resource
     */
    public suspend fun getStreamingPolicy(
        accountName: String,
        resourceGroupName: String,
        streamingPolicyName: String,
    ): GetStreamingPolicyResult {
        val argument = GetStreamingPolicyPlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
            streamingPolicyName = streamingPolicyName,
        )
        return getStreamingPolicyResultToKotlin(getStreamingPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getStreamingPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;media&#46;kotlin&#46;inputs&#46;GetStreamingPolicyPlainArgs].
     * @return A Streaming Policy resource
     */
    public suspend fun getStreamingPolicy(argument: suspend GetStreamingPolicyPlainArgsBuilder.() -> Unit): GetStreamingPolicyResult {
        val builder = GetStreamingPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getStreamingPolicyResultToKotlin(getStreamingPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the details of a Track in the Asset
     * Azure REST API version: 2023-01-01.
     * @param argument null
     * @return An Asset Track resource.
     */
    public suspend fun getTrack(argument: GetTrackPlainArgs): GetTrackResult =
        getTrackResultToKotlin(getTrackPlain(argument.toJava()).await())

    /**
     * @see [getTrack].
     * @param accountName The Media Services account name.
     * @param assetName The Asset name.
     * @param resourceGroupName The name of the resource group within the Azure subscription.
     * @param trackName The Asset Track name.
     * @return An Asset Track resource.
     */
    public suspend fun getTrack(
        accountName: String,
        assetName: String,
        resourceGroupName: String,
        trackName: String,
    ): GetTrackResult {
        val argument = GetTrackPlainArgs(
            accountName = accountName,
            assetName = assetName,
            resourceGroupName = resourceGroupName,
            trackName = trackName,
        )
        return getTrackResultToKotlin(getTrackPlain(argument.toJava()).await())
    }

    /**
     * @see [getTrack].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;media&#46;kotlin&#46;inputs&#46;GetTrackPlainArgs].
     * @return An Asset Track resource.
     */
    public suspend fun getTrack(argument: suspend GetTrackPlainArgsBuilder.() -> Unit): GetTrackResult {
        val builder = GetTrackPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTrackResultToKotlin(getTrackPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a Transform.
     * Azure REST API version: 2022-07-01.
     * @param argument null
     * @return A Transform encapsulates the rules or instructions for generating desired outputs from input media, such as by transcoding or by extracting insights. After the Transform is created, it can be applied to input media by creating Jobs.
     */
    public suspend fun getTransform(argument: GetTransformPlainArgs): GetTransformResult =
        getTransformResultToKotlin(getTransformPlain(argument.toJava()).await())

    /**
     * @see [getTransform].
     * @param accountName The Media Services account name.
     * @param resourceGroupName The name of the resource group within the Azure subscription.
     * @param transformName The Transform name.
     * @return A Transform encapsulates the rules or instructions for generating desired outputs from input media, such as by transcoding or by extracting insights. After the Transform is created, it can be applied to input media by creating Jobs.
     */
    public suspend fun getTransform(
        accountName: String,
        resourceGroupName: String,
        transformName: String,
    ): GetTransformResult {
        val argument = GetTransformPlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
            transformName = transformName,
        )
        return getTransformResultToKotlin(getTransformPlain(argument.toJava()).await())
    }

    /**
     * @see [getTransform].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;media&#46;kotlin&#46;inputs&#46;GetTransformPlainArgs].
     * @return A Transform encapsulates the rules or instructions for generating desired outputs from input media, such as by transcoding or by extracting insights. After the Transform is created, it can be applied to input media by creating Jobs.
     */
    public suspend fun getTransform(argument: suspend GetTransformPlainArgsBuilder.() -> Unit): GetTransformResult {
        val builder = GetTransformPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTransformResultToKotlin(getTransformPlain(builtArgument.toJava()).await())
    }

    /**
     * Lists storage container URLs with shared access signatures (SAS) for uploading and downloading Asset content. The signatures are derived from the storage account keys.
     * Azure REST API version: 2023-01-01.
     * @param argument null
     * @return The Asset Storage container SAS URLs.
     */
    public suspend fun listAssetContainerSas(argument: ListAssetContainerSasPlainArgs): ListAssetContainerSasResult =
        listAssetContainerSasResultToKotlin(listAssetContainerSasPlain(argument.toJava()).await())

    /**
     * @see [listAssetContainerSas].
     * @param accountName The Media Services account name.
     * @param assetName The Asset name.
     * @param expiryTime The SAS URL expiration time.  This must be less than 24 hours from the current time.
     * @param permissions The permissions to set on the SAS URL.
     * @param resourceGroupName The name of the resource group within the Azure subscription.
     * @return The Asset Storage container SAS URLs.
     */
    public suspend fun listAssetContainerSas(
        accountName: String,
        assetName: String,
        expiryTime: String? = null,
        permissions: Either<String, AssetContainerPermission>? = null,
        resourceGroupName: String,
    ): ListAssetContainerSasResult {
        val argument = ListAssetContainerSasPlainArgs(
            accountName = accountName,
            assetName = assetName,
            expiryTime = expiryTime,
            permissions = permissions,
            resourceGroupName = resourceGroupName,
        )
        return listAssetContainerSasResultToKotlin(listAssetContainerSasPlain(argument.toJava()).await())
    }

    /**
     * @see [listAssetContainerSas].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;media&#46;kotlin&#46;inputs&#46;ListAssetContainerSasPlainArgs].
     * @return The Asset Storage container SAS URLs.
     */
    public suspend fun listAssetContainerSas(argument: suspend ListAssetContainerSasPlainArgsBuilder.() -> Unit): ListAssetContainerSasResult {
        val builder = ListAssetContainerSasPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listAssetContainerSasResultToKotlin(listAssetContainerSasPlain(builtArgument.toJava()).await())
    }

    /**
     * Lists Streaming Locators which are associated with this asset.
     * Azure REST API version: 2023-01-01.
     * @param argument null
     * @return The Streaming Locators associated with this Asset.
     */
    public suspend fun listAssetStreamingLocators(argument: ListAssetStreamingLocatorsPlainArgs): ListAssetStreamingLocatorsResult =
        listAssetStreamingLocatorsResultToKotlin(listAssetStreamingLocatorsPlain(argument.toJava()).await())

    /**
     * @see [listAssetStreamingLocators].
     * @param accountName The Media Services account name.
     * @param assetName The Asset name.
     * @param resourceGroupName The name of the resource group within the Azure subscription.
     * @return The Streaming Locators associated with this Asset.
     */
    public suspend fun listAssetStreamingLocators(
        accountName: String,
        assetName: String,
        resourceGroupName: String,
    ): ListAssetStreamingLocatorsResult {
        val argument = ListAssetStreamingLocatorsPlainArgs(
            accountName = accountName,
            assetName = assetName,
            resourceGroupName = resourceGroupName,
        )
        return listAssetStreamingLocatorsResultToKotlin(listAssetStreamingLocatorsPlain(argument.toJava()).await())
    }

    /**
     * @see [listAssetStreamingLocators].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;media&#46;kotlin&#46;inputs&#46;ListAssetStreamingLocatorsPlainArgs].
     * @return The Streaming Locators associated with this Asset.
     */
    public suspend fun listAssetStreamingLocators(argument: suspend ListAssetStreamingLocatorsPlainArgsBuilder.() -> Unit): ListAssetStreamingLocatorsResult {
        val builder = ListAssetStreamingLocatorsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listAssetStreamingLocatorsResultToKotlin(listAssetStreamingLocatorsPlain(builtArgument.toJava()).await())
    }

    /**
     * List all the media edge policies associated with the Media Services account.
     * Azure REST API version: 2023-01-01.
     * @param argument null
     * @return null
     */
    public suspend fun listMediaServiceEdgePolicies(argument: ListMediaServiceEdgePoliciesPlainArgs): ListMediaServiceEdgePoliciesResult =
        listMediaServiceEdgePoliciesResultToKotlin(listMediaServiceEdgePoliciesPlain(argument.toJava()).await())

    /**
     * @see [listMediaServiceEdgePolicies].
     * @param accountName The Media Services account name.
     * @param deviceId Unique identifier of the edge device.
     * @param resourceGroupName The name of the resource group within the Azure subscription.
     * @return null
     */
    public suspend fun listMediaServiceEdgePolicies(
        accountName: String,
        deviceId: String? = null,
        resourceGroupName: String,
    ): ListMediaServiceEdgePoliciesResult {
        val argument = ListMediaServiceEdgePoliciesPlainArgs(
            accountName = accountName,
            deviceId = deviceId,
            resourceGroupName = resourceGroupName,
        )
        return listMediaServiceEdgePoliciesResultToKotlin(listMediaServiceEdgePoliciesPlain(argument.toJava()).await())
    }

    /**
     * @see [listMediaServiceEdgePolicies].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;media&#46;kotlin&#46;inputs&#46;ListMediaServiceEdgePoliciesPlainArgs].
     * @return null
     */
    public suspend fun listMediaServiceEdgePolicies(argument: suspend ListMediaServiceEdgePoliciesPlainArgsBuilder.() -> Unit): ListMediaServiceEdgePoliciesResult {
        val builder = ListMediaServiceEdgePoliciesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listMediaServiceEdgePoliciesResultToKotlin(listMediaServiceEdgePoliciesPlain(builtArgument.toJava()).await())
    }

    /**
     * Lists the keys for a Media Service.
     * Azure REST API version: 2015-10-01.
     * @param argument null
     * @return The response body for a ListKeys API.
     */
    public suspend fun listMediaServiceKeys(argument: ListMediaServiceKeysPlainArgs): ListMediaServiceKeysResult =
        listMediaServiceKeysResultToKotlin(listMediaServiceKeysPlain(argument.toJava()).await())

    /**
     * @see [listMediaServiceKeys].
     * @param mediaServiceName Name of the Media Service.
     * @param resourceGroupName Name of the resource group within the Azure subscription.
     * @return The response body for a ListKeys API.
     */
    public suspend fun listMediaServiceKeys(mediaServiceName: String, resourceGroupName: String): ListMediaServiceKeysResult {
        val argument = ListMediaServiceKeysPlainArgs(
            mediaServiceName = mediaServiceName,
            resourceGroupName = resourceGroupName,
        )
        return listMediaServiceKeysResultToKotlin(listMediaServiceKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listMediaServiceKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;media&#46;kotlin&#46;inputs&#46;ListMediaServiceKeysPlainArgs].
     * @return The response body for a ListKeys API.
     */
    public suspend fun listMediaServiceKeys(argument: suspend ListMediaServiceKeysPlainArgsBuilder.() -> Unit): ListMediaServiceKeysResult {
        val builder = ListMediaServiceKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listMediaServiceKeysResultToKotlin(listMediaServiceKeysPlain(builtArgument.toJava()).await())
    }

    /**
     * List Content Keys used by this Streaming Locator
     * Azure REST API version: 2023-01-01.
     * @param argument null
     * @return Class of response for listContentKeys action
     */
    public suspend fun listStreamingLocatorContentKeys(argument: ListStreamingLocatorContentKeysPlainArgs): ListStreamingLocatorContentKeysResult =
        listStreamingLocatorContentKeysResultToKotlin(listStreamingLocatorContentKeysPlain(argument.toJava()).await())

    /**
     * @see [listStreamingLocatorContentKeys].
     * @param accountName The Media Services account name.
     * @param resourceGroupName The name of the resource group within the Azure subscription.
     * @param streamingLocatorName The Streaming Locator name.
     * @return Class of response for listContentKeys action
     */
    public suspend fun listStreamingLocatorContentKeys(
        accountName: String,
        resourceGroupName: String,
        streamingLocatorName: String,
    ): ListStreamingLocatorContentKeysResult {
        val argument = ListStreamingLocatorContentKeysPlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
            streamingLocatorName = streamingLocatorName,
        )
        return listStreamingLocatorContentKeysResultToKotlin(listStreamingLocatorContentKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listStreamingLocatorContentKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;media&#46;kotlin&#46;inputs&#46;ListStreamingLocatorContentKeysPlainArgs].
     * @return Class of response for listContentKeys action
     */
    public suspend fun listStreamingLocatorContentKeys(argument: suspend ListStreamingLocatorContentKeysPlainArgsBuilder.() -> Unit): ListStreamingLocatorContentKeysResult {
        val builder = ListStreamingLocatorContentKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listStreamingLocatorContentKeysResultToKotlin(listStreamingLocatorContentKeysPlain(builtArgument.toJava()).await())
    }

    /**
     * List Paths supported by this Streaming Locator
     * Azure REST API version: 2023-01-01.
     * @param argument null
     * @return Class of response for listPaths action
     */
    public suspend fun listStreamingLocatorPaths(argument: ListStreamingLocatorPathsPlainArgs): ListStreamingLocatorPathsResult =
        listStreamingLocatorPathsResultToKotlin(listStreamingLocatorPathsPlain(argument.toJava()).await())

    /**
     * @see [listStreamingLocatorPaths].
     * @param accountName The Media Services account name.
     * @param resourceGroupName The name of the resource group within the Azure subscription.
     * @param streamingLocatorName The Streaming Locator name.
     * @return Class of response for listPaths action
     */
    public suspend fun listStreamingLocatorPaths(
        accountName: String,
        resourceGroupName: String,
        streamingLocatorName: String,
    ): ListStreamingLocatorPathsResult {
        val argument = ListStreamingLocatorPathsPlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
            streamingLocatorName = streamingLocatorName,
        )
        return listStreamingLocatorPathsResultToKotlin(listStreamingLocatorPathsPlain(argument.toJava()).await())
    }

    /**
     * @see [listStreamingLocatorPaths].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;media&#46;kotlin&#46;inputs&#46;ListStreamingLocatorPathsPlainArgs].
     * @return Class of response for listPaths action
     */
    public suspend fun listStreamingLocatorPaths(argument: suspend ListStreamingLocatorPathsPlainArgsBuilder.() -> Unit): ListStreamingLocatorPathsResult {
        val builder = ListStreamingLocatorPathsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listStreamingLocatorPathsResultToKotlin(listStreamingLocatorPathsPlain(builtArgument.toJava()).await())
    }
}
