@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin

import com.pulumi.azurenative.media.kotlin.outputs.MediaGraphAssetSinkResponse
import com.pulumi.azurenative.media.kotlin.outputs.MediaGraphRtspSourceResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.media.kotlin.outputs.MediaGraphAssetSinkResponse.Companion.toKotlin as mediaGraphAssetSinkResponseToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.MediaGraphRtspSourceResponse.Companion.toKotlin as mediaGraphRtspSourceResponseToKotlin

/**
 * Builder for [MediaGraph].
 */
@PulumiTagMarker
public class MediaGraphResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MediaGraphArgs = MediaGraphArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MediaGraphArgsBuilder.() -> Unit) {
        val builder = MediaGraphArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): MediaGraph {
        val builtJavaResource = com.pulumi.azurenative.media.MediaGraph(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return MediaGraph(builtJavaResource)
    }
}

/**
 * The Media Graph.
 * Azure REST API version: 2020-02-01-preview. Prior API version in Azure Native 1.x: 2020-02-01-preview.
 * ## Example Usage
 * ### Create or update a Media Graph with a clear RTSP Source
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var mediaGraph = new AzureNative.Media.MediaGraph("mediaGraph", new()
 *     {
 *         AccountName = "contosomedia",
 *         Description = "updated description",
 *         MediaGraphName = "SampleMediaGraph",
 *         ResourceGroupName = "contoso",
 *         Sinks = new[]
 *         {
 *             new AzureNative.Media.Inputs.MediaGraphAssetSinkArgs
 *             {
 *                 AssetName = "SampleAsset",
 *                 Inputs = new[]
 *                 {
 *                     "rtspSource",
 *                 },
 *                 Name = "AssetSink",
 *                 OdataType = "#Microsoft.Media.MediaGraphAssetSink",
 *             },
 *         },
 *         Sources = new[]
 *         {
 *             new AzureNative.Media.Inputs.MediaGraphRtspSourceArgs
 *             {
 *                 Endpoint = new AzureNative.Media.Inputs.MediaGraphClearEndpointArgs
 *                 {
 *                     Credentials = new AzureNative.Media.Inputs.MediaGraphUsernamePasswordCredentialsArgs
 *                     {
 *                         OdataType = "#Microsoft.Media.MediaGraphUsernamePasswordCredentials",
 *                         Password = "examplepassword",
 *                         Username = "exampleusername",
 *                     },
 *                     OdataType = "#Microsoft.Media.MediaGraphClearEndpoint",
 *                     Url = "rtsp://contoso.com:554/stream1",
 *                 },
 *                 Name = "rtspSource",
 *                 OdataType = "#Microsoft.Media.MediaGraphRtspSource",
 *                 Transport = AzureNative.Media.MediaGraphRtspTransport.Http,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := media.NewMediaGraph(ctx, "mediaGraph", &media.MediaGraphArgs{
 * AccountName: pulumi.String("contosomedia"),
 * Description: pulumi.String("updated description"),
 * MediaGraphName: pulumi.String("SampleMediaGraph"),
 * ResourceGroupName: pulumi.String("contoso"),
 * Sinks: media.MediaGraphAssetSinkArray{
 * interface{}{
 * AssetName: pulumi.String("SampleAsset"),
 * Inputs: pulumi.StringArray{
 * pulumi.String("rtspSource"),
 * },
 * Name: pulumi.String("AssetSink"),
 * OdataType: pulumi.String("#Microsoft.Media.MediaGraphAssetSink"),
 * },
 * },
 * Sources: media.MediaGraphRtspSourceArray{
 * interface{}{
 * Endpoint: media.MediaGraphClearEndpoint{
 * Credentials: media.MediaGraphUsernamePasswordCredentials{
 * OdataType: "#Microsoft.Media.MediaGraphUsernamePasswordCredentials",
 * Password: "examplepassword",
 * Username: "exampleusername",
 * },
 * OdataType: "#Microsoft.Media.MediaGraphClearEndpoint",
 * Url: "rtsp://contoso.com:554/stream1",
 * },
 * Name: pulumi.String("rtspSource"),
 * OdataType: pulumi.String("#Microsoft.Media.MediaGraphRtspSource"),
 * Transport: pulumi.String(media.MediaGraphRtspTransportHttp),
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.MediaGraph;
 * import com.pulumi.azurenative.media.MediaGraphArgs;
 * import com.pulumi.azurenative.media.inputs.MediaGraphAssetSinkArgs;
 * import com.pulumi.azurenative.media.inputs.MediaGraphRtspSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var mediaGraph = new MediaGraph("mediaGraph", MediaGraphArgs.builder()
 *             .accountName("contosomedia")
 *             .description("updated description")
 *             .mediaGraphName("SampleMediaGraph")
 *             .resourceGroupName("contoso")
 *             .sinks(MediaGraphAssetSinkArgs.builder()
 *                 .assetName("SampleAsset")
 *                 .inputs("rtspSource")
 *                 .name("AssetSink")
 *                 .odataType("#Microsoft.Media.MediaGraphAssetSink")
 *                 .build())
 *             .sources(MediaGraphRtspSourceArgs.builder()
 *                 .endpoint(MediaGraphClearEndpointArgs.builder()
 *                     .credentials(MediaGraphUsernamePasswordCredentialsArgs.builder()
 *                         .odataType("#Microsoft.Media.MediaGraphUsernamePasswordCredentials")
 *                         .password("examplepassword")
 *                         .username("exampleusername")
 *                         .build())
 *                     .odataType("#Microsoft.Media.MediaGraphClearEndpoint")
 *                     .url("rtsp://contoso.com:554/stream1")
 *                     .build())
 *                 .name("rtspSource")
 *                 .odataType("#Microsoft.Media.MediaGraphRtspSource")
 *                 .transport("Http")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a Media Graph with an encrypted RTSP Source
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var mediaGraph = new AzureNative.Media.MediaGraph("mediaGraph", new()
 *     {
 *         AccountName = "contosomedia",
 *         Description = "updated description",
 *         MediaGraphName = "SampleMediaGraph",
 *         ResourceGroupName = "contoso",
 *         Sinks = new[]
 *         {
 *             new AzureNative.Media.Inputs.MediaGraphAssetSinkArgs
 *             {
 *                 AssetName = "SampleAsset",
 *                 Inputs = new[]
 *                 {
 *                     "rtspSource",
 *                 },
 *                 Name = "AssetSink",
 *                 OdataType = "#Microsoft.Media.MediaGraphAssetSink",
 *             },
 *         },
 *         Sources = new[]
 *         {
 *             new AzureNative.Media.Inputs.MediaGraphRtspSourceArgs
 *             {
 *                 Endpoint = new AzureNative.Media.Inputs.MediaGraphTlsEndpointArgs
 *                 {
 *                     Credentials = new AzureNative.Media.Inputs.MediaGraphUsernamePasswordCredentialsArgs
 *                     {
 *                         OdataType = "#Microsoft.Media.MediaGraphUsernamePasswordCredentials",
 *                         Password = "examplepassword",
 *                         Username = "exampleusername",
 *                     },
 *                     OdataType = "#Microsoft.Media.MediaGraphTlsEndpoint",
 *                     TrustedCertificates = new AzureNative.Media.Inputs.MediaGraphPemCertificateListArgs
 *                     {
 *                         Certificates = new[]
 *                         {
 *                             @"-----BEGIN CERTIFICATE-----
 * MIIDhTCCAm2gAwIBAgIUajvPKmoO+8qaO89/ZGATl7ZYnTswDQYJKoZIhvcNAQEL
 * BQAwUTESMBAGA1UECgwJTWljcm9zb2Z0MRQwEgYDVQQLDAtBenVyZSBNZWRpYTEl
 * MCMGA1UEAwwcKFVudHJ1c3RlZCkgVGVzdCBDZXJ0aWZpY2F0ZTAgFw0yMDAyMDYy
 * MTI5MTlaGA8zMDE5MDYwOTIxMjkxOVowUTESMBAGA1UECgwJTWljcm9zb2Z0MRQw
 * EgYDVQQLDAtBenVyZSBNZWRpYTElMCMGA1UEAwwcKFVudHJ1c3RlZCkgVGVzdCBD
 * ZXJ0aWZpY2F0ZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAK2lg5ff
 * 7xXPaBZXHl/zrTukdiBtu7BNIOchHba51eloruPRzpvQx7Pedk3CVTut7LYinijf
 * uol0EwkQ2FLt2i2jOqiva9nXR95ujIZHcKsEeMC4RSNSP4++k6SpP8FgyYVdv5ru
 * f8GC+HyYQ4j0TqpR/cJs53l/LGRSldaFZ6fcDde1jeyca4VivAbAH1/WDIOvmjzo
 * 9XIGxZ10VSS5l5+DIgdkJZ+mDMLJIuVZ0YVF16ZGEB3beq1trk5lItvmSjQLTllH
 * qMFm9UGY8jKZSo/BY8ewHEtnGSAFQK0TVuRx1HhUWwu6C9jk+2zmRS2090BNpQWa
 * JMKFJrSPzFDPRX8CAwEAAaNTMFEwHQYDVR0OBBYEFIumbhu0lYk0EFDThEg0yyIn
 * /wZZMB8GA1UdIwQYMBaAFIumbhu0lYk0EFDThEg0yyIn/wZZMA8GA1UdEwEB/wQF
 * MAMBAf8wDQYJKoZIhvcNAQELBQADggEBADUNw+/NGNVtigq9tMJKqlk39MTpDn1s
 * Z1BVIAuAWSQjlevYZJeDIPUiWNWFhRe+xN7oOLnn2+NIXEKKeMSyuPoZYbN0mBkB
 * 99oS3XVipSANpmDvIepNdCrOnjfqDFIifRF1Dqjtb6i1hb6v/qYKVPLQvcrgGur7
 * PKKkAu9p4YRZ3RBdwwaUuMgojrj/l6DGbeJY6IRVnVMY39rryMnZjA5xUlhCu55n
 * oB3t/jsJLwnQN+JbAjLAeuqgOWtgARsEFzvpt+VvDsaj0YLOJPhyJwTvHgaa/slB
 * nECzd3TuyFKYeGssSni/QQ1e7yZcLapQqz66g5otdriw0IRdOfDxm5M=
 * -----END CERTIFICATE-----",
 *                         },
 *                         OdataType = "#Microsoft.Media.MediaGraphPemCertificateList",
 *                     },
 *                     Url = "rtsps://contoso.com:443/stream1",
 *                     ValidationOptions = new AzureNative.Media.Inputs.MediaGraphTlsValidationOptionsArgs
 *                     {
 *                         IgnoreHostname = true,
 *                         IgnoreSignature = false,
 *                     },
 *                 },
 *                 Name = "rtspSource",
 *                 OdataType = "#Microsoft.Media.MediaGraphRtspSource",
 *                 Transport = AzureNative.Media.MediaGraphRtspTransport.Http,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := media.NewMediaGraph(ctx, "mediaGraph", &media.MediaGraphArgs{
 * AccountName: pulumi.String("contosomedia"),
 * Description: pulumi.String("updated description"),
 * MediaGraphName: pulumi.String("SampleMediaGraph"),
 * ResourceGroupName: pulumi.String("contoso"),
 * Sinks: media.MediaGraphAssetSinkArray{
 * interface{}{
 * AssetName: pulumi.String("SampleAsset"),
 * Inputs: pulumi.StringArray{
 * pulumi.String("rtspSource"),
 * },
 * Name: pulumi.String("AssetSink"),
 * OdataType: pulumi.String("#Microsoft.Media.MediaGraphAssetSink"),
 * },
 * },
 * Sources: media.MediaGraphRtspSourceArray{
 * interface{}{
 * Endpoint: media.MediaGraphTlsEndpoint{
 * Credentials: media.MediaGraphUsernamePasswordCredentials{
 * OdataType: "#Microsoft.Media.MediaGraphUsernamePasswordCredentials",
 * Password: "examplepassword",
 * Username: "exampleusername",
 * },
 * OdataType: "#Microsoft.Media.MediaGraphTlsEndpoint",
 * TrustedCertificates: media.MediaGraphPemCertificateList{
 * Certificates: []string{
 * `-----BEGIN CERTIFICATE-----
 * MIIDhTCCAm2gAwIBAgIUajvPKmoO+8qaO89/ZGATl7ZYnTswDQYJKoZIhvcNAQEL
 * BQAwUTESMBAGA1UECgwJTWljcm9zb2Z0MRQwEgYDVQQLDAtBenVyZSBNZWRpYTEl
 * MCMGA1UEAwwcKFVudHJ1c3RlZCkgVGVzdCBDZXJ0aWZpY2F0ZTAgFw0yMDAyMDYy
 * MTI5MTlaGA8zMDE5MDYwOTIxMjkxOVowUTESMBAGA1UECgwJTWljcm9zb2Z0MRQw
 * EgYDVQQLDAtBenVyZSBNZWRpYTElMCMGA1UEAwwcKFVudHJ1c3RlZCkgVGVzdCBD
 * ZXJ0aWZpY2F0ZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAK2lg5ff
 * 7xXPaBZXHl/zrTukdiBtu7BNIOchHba51eloruPRzpvQx7Pedk3CVTut7LYinijf
 * uol0EwkQ2FLt2i2jOqiva9nXR95ujIZHcKsEeMC4RSNSP4++k6SpP8FgyYVdv5ru
 * f8GC+HyYQ4j0TqpR/cJs53l/LGRSldaFZ6fcDde1jeyca4VivAbAH1/WDIOvmjzo
 * 9XIGxZ10VSS5l5+DIgdkJZ+mDMLJIuVZ0YVF16ZGEB3beq1trk5lItvmSjQLTllH
 * qMFm9UGY8jKZSo/BY8ewHEtnGSAFQK0TVuRx1HhUWwu6C9jk+2zmRS2090BNpQWa
 * JMKFJrSPzFDPRX8CAwEAAaNTMFEwHQYDVR0OBBYEFIumbhu0lYk0EFDThEg0yyIn
 * /wZZMB8GA1UdIwQYMBaAFIumbhu0lYk0EFDThEg0yyIn/wZZMA8GA1UdEwEB/wQF
 * MAMBAf8wDQYJKoZIhvcNAQELBQADggEBADUNw+/NGNVtigq9tMJKqlk39MTpDn1s
 * Z1BVIAuAWSQjlevYZJeDIPUiWNWFhRe+xN7oOLnn2+NIXEKKeMSyuPoZYbN0mBkB
 * 99oS3XVipSANpmDvIepNdCrOnjfqDFIifRF1Dqjtb6i1hb6v/qYKVPLQvcrgGur7
 * PKKkAu9p4YRZ3RBdwwaUuMgojrj/l6DGbeJY6IRVnVMY39rryMnZjA5xUlhCu55n
 * oB3t/jsJLwnQN+JbAjLAeuqgOWtgARsEFzvpt+VvDsaj0YLOJPhyJwTvHgaa/slB
 * nECzd3TuyFKYeGssSni/QQ1e7yZcLapQqz66g5otdriw0IRdOfDxm5M=
 * -----END CERTIFICATE-----`,
 * },
 * OdataType: "#Microsoft.Media.MediaGraphPemCertificateList",
 * },
 * Url: "rtsps://contoso.com:443/stream1",
 * ValidationOptions: media.MediaGraphTlsValidationOptions{
 * IgnoreHostname: true,
 * IgnoreSignature: false,
 * },
 * },
 * Name: pulumi.String("rtspSource"),
 * OdataType: pulumi.String("#Microsoft.Media.MediaGraphRtspSource"),
 * Transport: pulumi.String(media.MediaGraphRtspTransportHttp),
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.MediaGraph;
 * import com.pulumi.azurenative.media.MediaGraphArgs;
 * import com.pulumi.azurenative.media.inputs.MediaGraphAssetSinkArgs;
 * import com.pulumi.azurenative.media.inputs.MediaGraphRtspSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var mediaGraph = new MediaGraph("mediaGraph", MediaGraphArgs.builder()
 *             .accountName("contosomedia")
 *             .description("updated description")
 *             .mediaGraphName("SampleMediaGraph")
 *             .resourceGroupName("contoso")
 *             .sinks(MediaGraphAssetSinkArgs.builder()
 *                 .assetName("SampleAsset")
 *                 .inputs("rtspSource")
 *                 .name("AssetSink")
 *                 .odataType("#Microsoft.Media.MediaGraphAssetSink")
 *                 .build())
 *             .sources(MediaGraphRtspSourceArgs.builder()
 *                 .endpoint(MediaGraphClearEndpointArgs.builder()
 *                     .credentials(MediaGraphUsernamePasswordCredentialsArgs.builder()
 *                         .odataType("#Microsoft.Media.MediaGraphUsernamePasswordCredentials")
 *                         .password("examplepassword")
 *                         .username("exampleusername")
 *                         .build())
 *                     .odataType("#Microsoft.Media.MediaGraphTlsEndpoint")
 *                     .trustedCertificates(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                     .url("rtsps://contoso.com:443/stream1")
 *                     .validationOptions(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                     .build())
 *                 .name("rtspSource")
 *                 .odataType("#Microsoft.Media.MediaGraphRtspSource")
 *                 .transport("Http")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:media:MediaGraph SampleMediaGraph /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/mediaGraphs/{mediaGraphName}
 * ```
 */
public class MediaGraph internal constructor(
    override val javaResource: com.pulumi.azurenative.media.MediaGraph,
) : KotlinCustomResource(javaResource, MediaGraphMapper) {
    /**
     * Date the Media Graph was created.
     */
    public val created: Output<String>
        get() = javaResource.created().applyValue({ args0 -> args0 })

    /**
     * Media Graph description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Date the Media Graph was last modified.
     */
    public val lastModified: Output<String>
        get() = javaResource.lastModified().applyValue({ args0 -> args0 })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Media Graph sinks.
     */
    public val sinks: Output<List<MediaGraphAssetSinkResponse>>
        get() = javaResource.sinks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    mediaGraphAssetSinkResponseToKotlin(args0)
                })
            })
        })

    /**
     * Media Graph sources.
     */
    public val sources: Output<List<MediaGraphRtspSourceResponse>>
        get() = javaResource.sources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    mediaGraphRtspSourceResponseToKotlin(args0)
                })
            })
        })

    /**
     * Media Graph state which indicates the resource allocation status for running the media graph pipeline.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object MediaGraphMapper : ResourceMapper<MediaGraph> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.media.MediaGraph::class == javaResource::class

    override fun map(javaResource: Resource): MediaGraph = MediaGraph(
        javaResource as
            com.pulumi.azurenative.media.MediaGraph,
    )
}

/**
 * @see [MediaGraph].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MediaGraph].
 */
public suspend fun mediaGraph(name: String, block: suspend MediaGraphResourceBuilder.() -> Unit): MediaGraph {
    val builder = MediaGraphResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MediaGraph].
 * @param name The _unique_ name of the resulting resource.
 */
public fun mediaGraph(name: String): MediaGraph {
    val builder = MediaGraphResourceBuilder()
    builder.name(name)
    return builder.build()
}
