@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin

import com.pulumi.azurenative.media.MediaGraphArgs.builder
import com.pulumi.azurenative.media.kotlin.inputs.MediaGraphAssetSinkArgs
import com.pulumi.azurenative.media.kotlin.inputs.MediaGraphAssetSinkArgsBuilder
import com.pulumi.azurenative.media.kotlin.inputs.MediaGraphRtspSourceArgs
import com.pulumi.azurenative.media.kotlin.inputs.MediaGraphRtspSourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The Media Graph.
 * Azure REST API version: 2020-02-01-preview. Prior API version in Azure Native 1.x: 2020-02-01-preview.
 * ## Example Usage
 * ### Create or update a Media Graph with a clear RTSP Source
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var mediaGraph = new AzureNative.Media.MediaGraph("mediaGraph", new()
 *     {
 *         AccountName = "contosomedia",
 *         Description = "updated description",
 *         MediaGraphName = "SampleMediaGraph",
 *         ResourceGroupName = "contoso",
 *         Sinks = new[]
 *         {
 *             new AzureNative.Media.Inputs.MediaGraphAssetSinkArgs
 *             {
 *                 AssetName = "SampleAsset",
 *                 Inputs = new[]
 *                 {
 *                     "rtspSource",
 *                 },
 *                 Name = "AssetSink",
 *                 OdataType = "#Microsoft.Media.MediaGraphAssetSink",
 *             },
 *         },
 *         Sources = new[]
 *         {
 *             new AzureNative.Media.Inputs.MediaGraphRtspSourceArgs
 *             {
 *                 Endpoint = new AzureNative.Media.Inputs.MediaGraphClearEndpointArgs
 *                 {
 *                     Credentials = new AzureNative.Media.Inputs.MediaGraphUsernamePasswordCredentialsArgs
 *                     {
 *                         OdataType = "#Microsoft.Media.MediaGraphUsernamePasswordCredentials",
 *                         Password = "examplepassword",
 *                         Username = "exampleusername",
 *                     },
 *                     OdataType = "#Microsoft.Media.MediaGraphClearEndpoint",
 *                     Url = "rtsp://contoso.com:554/stream1",
 *                 },
 *                 Name = "rtspSource",
 *                 OdataType = "#Microsoft.Media.MediaGraphRtspSource",
 *                 Transport = AzureNative.Media.MediaGraphRtspTransport.Http,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := media.NewMediaGraph(ctx, "mediaGraph", &media.MediaGraphArgs{
 * AccountName: pulumi.String("contosomedia"),
 * Description: pulumi.String("updated description"),
 * MediaGraphName: pulumi.String("SampleMediaGraph"),
 * ResourceGroupName: pulumi.String("contoso"),
 * Sinks: media.MediaGraphAssetSinkArray{
 * interface{}{
 * AssetName: pulumi.String("SampleAsset"),
 * Inputs: pulumi.StringArray{
 * pulumi.String("rtspSource"),
 * },
 * Name: pulumi.String("AssetSink"),
 * OdataType: pulumi.String("#Microsoft.Media.MediaGraphAssetSink"),
 * },
 * },
 * Sources: media.MediaGraphRtspSourceArray{
 * interface{}{
 * Endpoint: media.MediaGraphClearEndpoint{
 * Credentials: media.MediaGraphUsernamePasswordCredentials{
 * OdataType: "#Microsoft.Media.MediaGraphUsernamePasswordCredentials",
 * Password: "examplepassword",
 * Username: "exampleusername",
 * },
 * OdataType: "#Microsoft.Media.MediaGraphClearEndpoint",
 * Url: "rtsp://contoso.com:554/stream1",
 * },
 * Name: pulumi.String("rtspSource"),
 * OdataType: pulumi.String("#Microsoft.Media.MediaGraphRtspSource"),
 * Transport: pulumi.String(media.MediaGraphRtspTransportHttp),
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.MediaGraph;
 * import com.pulumi.azurenative.media.MediaGraphArgs;
 * import com.pulumi.azurenative.media.inputs.MediaGraphAssetSinkArgs;
 * import com.pulumi.azurenative.media.inputs.MediaGraphRtspSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var mediaGraph = new MediaGraph("mediaGraph", MediaGraphArgs.builder()
 *             .accountName("contosomedia")
 *             .description("updated description")
 *             .mediaGraphName("SampleMediaGraph")
 *             .resourceGroupName("contoso")
 *             .sinks(MediaGraphAssetSinkArgs.builder()
 *                 .assetName("SampleAsset")
 *                 .inputs("rtspSource")
 *                 .name("AssetSink")
 *                 .odataType("#Microsoft.Media.MediaGraphAssetSink")
 *                 .build())
 *             .sources(MediaGraphRtspSourceArgs.builder()
 *                 .endpoint(MediaGraphClearEndpointArgs.builder()
 *                     .credentials(MediaGraphUsernamePasswordCredentialsArgs.builder()
 *                         .odataType("#Microsoft.Media.MediaGraphUsernamePasswordCredentials")
 *                         .password("examplepassword")
 *                         .username("exampleusername")
 *                         .build())
 *                     .odataType("#Microsoft.Media.MediaGraphClearEndpoint")
 *                     .url("rtsp://contoso.com:554/stream1")
 *                     .build())
 *                 .name("rtspSource")
 *                 .odataType("#Microsoft.Media.MediaGraphRtspSource")
 *                 .transport("Http")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a Media Graph with an encrypted RTSP Source
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var mediaGraph = new AzureNative.Media.MediaGraph("mediaGraph", new()
 *     {
 *         AccountName = "contosomedia",
 *         Description = "updated description",
 *         MediaGraphName = "SampleMediaGraph",
 *         ResourceGroupName = "contoso",
 *         Sinks = new[]
 *         {
 *             new AzureNative.Media.Inputs.MediaGraphAssetSinkArgs
 *             {
 *                 AssetName = "SampleAsset",
 *                 Inputs = new[]
 *                 {
 *                     "rtspSource",
 *                 },
 *                 Name = "AssetSink",
 *                 OdataType = "#Microsoft.Media.MediaGraphAssetSink",
 *             },
 *         },
 *         Sources = new[]
 *         {
 *             new AzureNative.Media.Inputs.MediaGraphRtspSourceArgs
 *             {
 *                 Endpoint = new AzureNative.Media.Inputs.MediaGraphTlsEndpointArgs
 *                 {
 *                     Credentials = new AzureNative.Media.Inputs.MediaGraphUsernamePasswordCredentialsArgs
 *                     {
 *                         OdataType = "#Microsoft.Media.MediaGraphUsernamePasswordCredentials",
 *                         Password = "examplepassword",
 *                         Username = "exampleusername",
 *                     },
 *                     OdataType = "#Microsoft.Media.MediaGraphTlsEndpoint",
 *                     TrustedCertificates = new AzureNative.Media.Inputs.MediaGraphPemCertificateListArgs
 *                     {
 *                         Certificates = new[]
 *                         {
 *                             @"-----BEGIN CERTIFICATE-----
 * MIIDhTCCAm2gAwIBAgIUajvPKmoO+8qaO89/ZGATl7ZYnTswDQYJKoZIhvcNAQEL
 * BQAwUTESMBAGA1UECgwJTWljcm9zb2Z0MRQwEgYDVQQLDAtBenVyZSBNZWRpYTEl
 * MCMGA1UEAwwcKFVudHJ1c3RlZCkgVGVzdCBDZXJ0aWZpY2F0ZTAgFw0yMDAyMDYy
 * MTI5MTlaGA8zMDE5MDYwOTIxMjkxOVowUTESMBAGA1UECgwJTWljcm9zb2Z0MRQw
 * EgYDVQQLDAtBenVyZSBNZWRpYTElMCMGA1UEAwwcKFVudHJ1c3RlZCkgVGVzdCBD
 * ZXJ0aWZpY2F0ZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAK2lg5ff
 * 7xXPaBZXHl/zrTukdiBtu7BNIOchHba51eloruPRzpvQx7Pedk3CVTut7LYinijf
 * uol0EwkQ2FLt2i2jOqiva9nXR95ujIZHcKsEeMC4RSNSP4++k6SpP8FgyYVdv5ru
 * f8GC+HyYQ4j0TqpR/cJs53l/LGRSldaFZ6fcDde1jeyca4VivAbAH1/WDIOvmjzo
 * 9XIGxZ10VSS5l5+DIgdkJZ+mDMLJIuVZ0YVF16ZGEB3beq1trk5lItvmSjQLTllH
 * qMFm9UGY8jKZSo/BY8ewHEtnGSAFQK0TVuRx1HhUWwu6C9jk+2zmRS2090BNpQWa
 * JMKFJrSPzFDPRX8CAwEAAaNTMFEwHQYDVR0OBBYEFIumbhu0lYk0EFDThEg0yyIn
 * /wZZMB8GA1UdIwQYMBaAFIumbhu0lYk0EFDThEg0yyIn/wZZMA8GA1UdEwEB/wQF
 * MAMBAf8wDQYJKoZIhvcNAQELBQADggEBADUNw+/NGNVtigq9tMJKqlk39MTpDn1s
 * Z1BVIAuAWSQjlevYZJeDIPUiWNWFhRe+xN7oOLnn2+NIXEKKeMSyuPoZYbN0mBkB
 * 99oS3XVipSANpmDvIepNdCrOnjfqDFIifRF1Dqjtb6i1hb6v/qYKVPLQvcrgGur7
 * PKKkAu9p4YRZ3RBdwwaUuMgojrj/l6DGbeJY6IRVnVMY39rryMnZjA5xUlhCu55n
 * oB3t/jsJLwnQN+JbAjLAeuqgOWtgARsEFzvpt+VvDsaj0YLOJPhyJwTvHgaa/slB
 * nECzd3TuyFKYeGssSni/QQ1e7yZcLapQqz66g5otdriw0IRdOfDxm5M=
 * -----END CERTIFICATE-----",
 *                         },
 *                         OdataType = "#Microsoft.Media.MediaGraphPemCertificateList",
 *                     },
 *                     Url = "rtsps://contoso.com:443/stream1",
 *                     ValidationOptions = new AzureNative.Media.Inputs.MediaGraphTlsValidationOptionsArgs
 *                     {
 *                         IgnoreHostname = true,
 *                         IgnoreSignature = false,
 *                     },
 *                 },
 *                 Name = "rtspSource",
 *                 OdataType = "#Microsoft.Media.MediaGraphRtspSource",
 *                 Transport = AzureNative.Media.MediaGraphRtspTransport.Http,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := media.NewMediaGraph(ctx, "mediaGraph", &media.MediaGraphArgs{
 * AccountName: pulumi.String("contosomedia"),
 * Description: pulumi.String("updated description"),
 * MediaGraphName: pulumi.String("SampleMediaGraph"),
 * ResourceGroupName: pulumi.String("contoso"),
 * Sinks: media.MediaGraphAssetSinkArray{
 * interface{}{
 * AssetName: pulumi.String("SampleAsset"),
 * Inputs: pulumi.StringArray{
 * pulumi.String("rtspSource"),
 * },
 * Name: pulumi.String("AssetSink"),
 * OdataType: pulumi.String("#Microsoft.Media.MediaGraphAssetSink"),
 * },
 * },
 * Sources: media.MediaGraphRtspSourceArray{
 * interface{}{
 * Endpoint: media.MediaGraphTlsEndpoint{
 * Credentials: media.MediaGraphUsernamePasswordCredentials{
 * OdataType: "#Microsoft.Media.MediaGraphUsernamePasswordCredentials",
 * Password: "examplepassword",
 * Username: "exampleusername",
 * },
 * OdataType: "#Microsoft.Media.MediaGraphTlsEndpoint",
 * TrustedCertificates: media.MediaGraphPemCertificateList{
 * Certificates: []string{
 * `-----BEGIN CERTIFICATE-----
 * MIIDhTCCAm2gAwIBAgIUajvPKmoO+8qaO89/ZGATl7ZYnTswDQYJKoZIhvcNAQEL
 * BQAwUTESMBAGA1UECgwJTWljcm9zb2Z0MRQwEgYDVQQLDAtBenVyZSBNZWRpYTEl
 * MCMGA1UEAwwcKFVudHJ1c3RlZCkgVGVzdCBDZXJ0aWZpY2F0ZTAgFw0yMDAyMDYy
 * MTI5MTlaGA8zMDE5MDYwOTIxMjkxOVowUTESMBAGA1UECgwJTWljcm9zb2Z0MRQw
 * EgYDVQQLDAtBenVyZSBNZWRpYTElMCMGA1UEAwwcKFVudHJ1c3RlZCkgVGVzdCBD
 * ZXJ0aWZpY2F0ZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAK2lg5ff
 * 7xXPaBZXHl/zrTukdiBtu7BNIOchHba51eloruPRzpvQx7Pedk3CVTut7LYinijf
 * uol0EwkQ2FLt2i2jOqiva9nXR95ujIZHcKsEeMC4RSNSP4++k6SpP8FgyYVdv5ru
 * f8GC+HyYQ4j0TqpR/cJs53l/LGRSldaFZ6fcDde1jeyca4VivAbAH1/WDIOvmjzo
 * 9XIGxZ10VSS5l5+DIgdkJZ+mDMLJIuVZ0YVF16ZGEB3beq1trk5lItvmSjQLTllH
 * qMFm9UGY8jKZSo/BY8ewHEtnGSAFQK0TVuRx1HhUWwu6C9jk+2zmRS2090BNpQWa
 * JMKFJrSPzFDPRX8CAwEAAaNTMFEwHQYDVR0OBBYEFIumbhu0lYk0EFDThEg0yyIn
 * /wZZMB8GA1UdIwQYMBaAFIumbhu0lYk0EFDThEg0yyIn/wZZMA8GA1UdEwEB/wQF
 * MAMBAf8wDQYJKoZIhvcNAQELBQADggEBADUNw+/NGNVtigq9tMJKqlk39MTpDn1s
 * Z1BVIAuAWSQjlevYZJeDIPUiWNWFhRe+xN7oOLnn2+NIXEKKeMSyuPoZYbN0mBkB
 * 99oS3XVipSANpmDvIepNdCrOnjfqDFIifRF1Dqjtb6i1hb6v/qYKVPLQvcrgGur7
 * PKKkAu9p4YRZ3RBdwwaUuMgojrj/l6DGbeJY6IRVnVMY39rryMnZjA5xUlhCu55n
 * oB3t/jsJLwnQN+JbAjLAeuqgOWtgARsEFzvpt+VvDsaj0YLOJPhyJwTvHgaa/slB
 * nECzd3TuyFKYeGssSni/QQ1e7yZcLapQqz66g5otdriw0IRdOfDxm5M=
 * -----END CERTIFICATE-----`,
 * },
 * OdataType: "#Microsoft.Media.MediaGraphPemCertificateList",
 * },
 * Url: "rtsps://contoso.com:443/stream1",
 * ValidationOptions: media.MediaGraphTlsValidationOptions{
 * IgnoreHostname: true,
 * IgnoreSignature: false,
 * },
 * },
 * Name: pulumi.String("rtspSource"),
 * OdataType: pulumi.String("#Microsoft.Media.MediaGraphRtspSource"),
 * Transport: pulumi.String(media.MediaGraphRtspTransportHttp),
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.MediaGraph;
 * import com.pulumi.azurenative.media.MediaGraphArgs;
 * import com.pulumi.azurenative.media.inputs.MediaGraphAssetSinkArgs;
 * import com.pulumi.azurenative.media.inputs.MediaGraphRtspSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var mediaGraph = new MediaGraph("mediaGraph", MediaGraphArgs.builder()
 *             .accountName("contosomedia")
 *             .description("updated description")
 *             .mediaGraphName("SampleMediaGraph")
 *             .resourceGroupName("contoso")
 *             .sinks(MediaGraphAssetSinkArgs.builder()
 *                 .assetName("SampleAsset")
 *                 .inputs("rtspSource")
 *                 .name("AssetSink")
 *                 .odataType("#Microsoft.Media.MediaGraphAssetSink")
 *                 .build())
 *             .sources(MediaGraphRtspSourceArgs.builder()
 *                 .endpoint(MediaGraphClearEndpointArgs.builder()
 *                     .credentials(MediaGraphUsernamePasswordCredentialsArgs.builder()
 *                         .odataType("#Microsoft.Media.MediaGraphUsernamePasswordCredentials")
 *                         .password("examplepassword")
 *                         .username("exampleusername")
 *                         .build())
 *                     .odataType("#Microsoft.Media.MediaGraphTlsEndpoint")
 *                     .trustedCertificates(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                     .url("rtsps://contoso.com:443/stream1")
 *                     .validationOptions(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                     .build())
 *                 .name("rtspSource")
 *                 .odataType("#Microsoft.Media.MediaGraphRtspSource")
 *                 .transport("Http")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:media:MediaGraph SampleMediaGraph /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/mediaGraphs/{mediaGraphName}
 * ```
 * @property accountName The Media Services account name.
 * @property description Media Graph description.
 * @property mediaGraphName The Media Graph name.
 * @property resourceGroupName The name of the resource group within the Azure subscription.
 * @property sinks Media Graph sinks.
 * @property sources Media Graph sources.
 */
public data class MediaGraphArgs(
    public val accountName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val mediaGraphName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sinks: Output<List<MediaGraphAssetSinkArgs>>? = null,
    public val sources: Output<List<MediaGraphRtspSourceArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.MediaGraphArgs> {
    override fun toJava(): com.pulumi.azurenative.media.MediaGraphArgs =
        com.pulumi.azurenative.media.MediaGraphArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .mediaGraphName(mediaGraphName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sinks(sinks?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .sources(
                sources?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [MediaGraphArgs].
 */
@PulumiTagMarker
public class MediaGraphArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var description: Output<String>? = null

    private var mediaGraphName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sinks: Output<List<MediaGraphAssetSinkArgs>>? = null

    private var sources: Output<List<MediaGraphRtspSourceArgs>>? = null

    /**
     * @param value The Media Services account name.
     */
    @JvmName("axbjvshvwytsfyik")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Media Graph description.
     */
    @JvmName("dotabqlseypxdkqc")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The Media Graph name.
     */
    @JvmName("xnqljsxqgrwflsfx")
    public suspend fun mediaGraphName(`value`: Output<String>) {
        this.mediaGraphName = value
    }

    /**
     * @param value The name of the resource group within the Azure subscription.
     */
    @JvmName("kiwlqrdoupvwtgll")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Media Graph sinks.
     */
    @JvmName("tfgbxiqrtuhqjwyt")
    public suspend fun sinks(`value`: Output<List<MediaGraphAssetSinkArgs>>) {
        this.sinks = value
    }

    @JvmName("hanprnrnwqhtmlpm")
    public suspend fun sinks(vararg values: Output<MediaGraphAssetSinkArgs>) {
        this.sinks = Output.all(values.asList())
    }

    /**
     * @param values Media Graph sinks.
     */
    @JvmName("iiirvucelfwcnlep")
    public suspend fun sinks(values: List<Output<MediaGraphAssetSinkArgs>>) {
        this.sinks = Output.all(values)
    }

    /**
     * @param value Media Graph sources.
     */
    @JvmName("iwxjcdyosgparthg")
    public suspend fun sources(`value`: Output<List<MediaGraphRtspSourceArgs>>) {
        this.sources = value
    }

    @JvmName("uiyvenswpucmkuoa")
    public suspend fun sources(vararg values: Output<MediaGraphRtspSourceArgs>) {
        this.sources = Output.all(values.asList())
    }

    /**
     * @param values Media Graph sources.
     */
    @JvmName("ojoqqjqbptsjjogl")
    public suspend fun sources(values: List<Output<MediaGraphRtspSourceArgs>>) {
        this.sources = Output.all(values)
    }

    /**
     * @param value The Media Services account name.
     */
    @JvmName("gptttivcsphawhqg")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Media Graph description.
     */
    @JvmName("ivaeyrrgvmxvunic")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The Media Graph name.
     */
    @JvmName("swvsurdbbxiwgkck")
    public suspend fun mediaGraphName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mediaGraphName = mapped
    }

    /**
     * @param value The name of the resource group within the Azure subscription.
     */
    @JvmName("avpxscsakwbmghqf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Media Graph sinks.
     */
    @JvmName("ljhoadriknlumfvj")
    public suspend fun sinks(`value`: List<MediaGraphAssetSinkArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sinks = mapped
    }

    /**
     * @param argument Media Graph sinks.
     */
    @JvmName("impwhqifyveusaet")
    public suspend fun sinks(argument: List<suspend MediaGraphAssetSinkArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MediaGraphAssetSinkArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sinks = mapped
    }

    /**
     * @param argument Media Graph sinks.
     */
    @JvmName("afvvsvjvardoxuep")
    public suspend fun sinks(vararg argument: suspend MediaGraphAssetSinkArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            MediaGraphAssetSinkArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sinks = mapped
    }

    /**
     * @param argument Media Graph sinks.
     */
    @JvmName("cqrjeebqowwxjaxt")
    public suspend fun sinks(argument: suspend MediaGraphAssetSinkArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(MediaGraphAssetSinkArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sinks = mapped
    }

    /**
     * @param values Media Graph sinks.
     */
    @JvmName("ubvoxvwmysjplyhc")
    public suspend fun sinks(vararg values: MediaGraphAssetSinkArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sinks = mapped
    }

    /**
     * @param value Media Graph sources.
     */
    @JvmName("ldxbpskwpjmtcifq")
    public suspend fun sources(`value`: List<MediaGraphRtspSourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sources = mapped
    }

    /**
     * @param argument Media Graph sources.
     */
    @JvmName("fmpomvpoiwklcuty")
    public suspend fun sources(argument: List<suspend MediaGraphRtspSourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MediaGraphRtspSourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param argument Media Graph sources.
     */
    @JvmName("eeuwytgjuycumxuo")
    public suspend fun sources(vararg argument: suspend MediaGraphRtspSourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            MediaGraphRtspSourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param argument Media Graph sources.
     */
    @JvmName("dshnvnsmgxjvcdyo")
    public suspend fun sources(argument: suspend MediaGraphRtspSourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(MediaGraphRtspSourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param values Media Graph sources.
     */
    @JvmName("gvvsrrwueihuayoh")
    public suspend fun sources(vararg values: MediaGraphRtspSourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sources = mapped
    }

    internal fun build(): MediaGraphArgs = MediaGraphArgs(
        accountName = accountName,
        description = description,
        mediaGraphName = mediaGraphName,
        resourceGroupName = resourceGroupName,
        sinks = sinks,
        sources = sources,
    )
}
