@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin

import com.pulumi.azurenative.media.kotlin.outputs.CommonEncryptionCbcsResponse
import com.pulumi.azurenative.media.kotlin.outputs.CommonEncryptionCencResponse
import com.pulumi.azurenative.media.kotlin.outputs.EnvelopeEncryptionResponse
import com.pulumi.azurenative.media.kotlin.outputs.NoEncryptionResponse
import com.pulumi.azurenative.media.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.media.kotlin.outputs.CommonEncryptionCbcsResponse.Companion.toKotlin as commonEncryptionCbcsResponseToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.CommonEncryptionCencResponse.Companion.toKotlin as commonEncryptionCencResponseToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.EnvelopeEncryptionResponse.Companion.toKotlin as envelopeEncryptionResponseToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.NoEncryptionResponse.Companion.toKotlin as noEncryptionResponseToKotlin
import com.pulumi.azurenative.media.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [StreamingPolicy].
 */
@PulumiTagMarker
public class StreamingPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StreamingPolicyArgs = StreamingPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StreamingPolicyArgsBuilder.() -> Unit) {
        val builder = StreamingPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): StreamingPolicy {
        val builtJavaResource = com.pulumi.azurenative.media.StreamingPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return StreamingPolicy(builtJavaResource)
    }
}

/**
 * A Streaming Policy resource
 * Azure REST API version: 2023-01-01. Prior API version in Azure Native 1.x: 2020-05-01.
 * ## Example Usage
 * ### Creates a Streaming Policy with ClearKey encryption in commonEncryptionCbcs.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var streamingPolicy = new AzureNative.Media.StreamingPolicy("streamingPolicy", new()
 *     {
 *         AccountName = "contosomedia",
 *         CommonEncryptionCbcs = new AzureNative.Media.Inputs.CommonEncryptionCbcsArgs
 *         {
 *             ClearKeyEncryptionConfiguration = new AzureNative.Media.Inputs.ClearKeyEncryptionConfigurationArgs
 *             {
 *                 CustomKeysAcquisitionUrlTemplate = "https://contoso.com/{AlternativeMediaId}/clearkey/",
 *             },
 *             ContentKeys = new AzureNative.Media.Inputs.StreamingPolicyContentKeysArgs
 *             {
 *                 DefaultKey = new AzureNative.Media.Inputs.DefaultKeyArgs
 *                 {
 *                     Label = "cbcsDefaultKey",
 *                 },
 *             },
 *             EnabledProtocols = new AzureNative.Media.Inputs.EnabledProtocolsArgs
 *             {
 *                 Dash = false,
 *                 Download = false,
 *                 Hls = true,
 *                 SmoothStreaming = false,
 *             },
 *         },
 *         DefaultContentKeyPolicyName = "PolicyWithMultipleOptions",
 *         ResourceGroupName = "contosorg",
 *         StreamingPolicyName = "UserCreatedSecureStreamingPolicyWithCommonEncryptionCbcsOnly",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := media.NewStreamingPolicy(ctx, "streamingPolicy", &media.StreamingPolicyArgs{
 * 			AccountName: pulumi.String("contosomedia"),
 * 			CommonEncryptionCbcs: &media.CommonEncryptionCbcsArgs{
 * 				ClearKeyEncryptionConfiguration: &media.ClearKeyEncryptionConfigurationArgs{
 * 					CustomKeysAcquisitionUrlTemplate: pulumi.String("https://contoso.com/{AlternativeMediaId}/clearkey/"),
 * 				},
 * 				ContentKeys: &media.StreamingPolicyContentKeysArgs{
 * 					DefaultKey: &media.DefaultKeyArgs{
 * 						Label: pulumi.String("cbcsDefaultKey"),
 * 					},
 * 				},
 * 				EnabledProtocols: &media.EnabledProtocolsArgs{
 * 					Dash:            pulumi.Bool(false),
 * 					Download:        pulumi.Bool(false),
 * 					Hls:             pulumi.Bool(true),
 * 					SmoothStreaming: pulumi.Bool(false),
 * 				},
 * 			},
 * 			DefaultContentKeyPolicyName: pulumi.String("PolicyWithMultipleOptions"),
 * 			ResourceGroupName:           pulumi.String("contosorg"),
 * 			StreamingPolicyName:         pulumi.String("UserCreatedSecureStreamingPolicyWithCommonEncryptionCbcsOnly"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.StreamingPolicy;
 * import com.pulumi.azurenative.media.StreamingPolicyArgs;
 * import com.pulumi.azurenative.media.inputs.CommonEncryptionCbcsArgs;
 * import com.pulumi.azurenative.media.inputs.ClearKeyEncryptionConfigurationArgs;
 * import com.pulumi.azurenative.media.inputs.StreamingPolicyContentKeysArgs;
 * import com.pulumi.azurenative.media.inputs.DefaultKeyArgs;
 * import com.pulumi.azurenative.media.inputs.EnabledProtocolsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var streamingPolicy = new StreamingPolicy("streamingPolicy", StreamingPolicyArgs.builder()
 *             .accountName("contosomedia")
 *             .commonEncryptionCbcs(CommonEncryptionCbcsArgs.builder()
 *                 .clearKeyEncryptionConfiguration(ClearKeyEncryptionConfigurationArgs.builder()
 *                     .customKeysAcquisitionUrlTemplate("https://contoso.com/{AlternativeMediaId}/clearkey/")
 *                     .build())
 *                 .contentKeys(StreamingPolicyContentKeysArgs.builder()
 *                     .defaultKey(DefaultKeyArgs.builder()
 *                         .label("cbcsDefaultKey")
 *                         .build())
 *                     .build())
 *                 .enabledProtocols(EnabledProtocolsArgs.builder()
 *                     .dash(false)
 *                     .download(false)
 *                     .hls(true)
 *                     .smoothStreaming(false)
 *                     .build())
 *                 .build())
 *             .defaultContentKeyPolicyName("PolicyWithMultipleOptions")
 *             .resourceGroupName("contosorg")
 *             .streamingPolicyName("UserCreatedSecureStreamingPolicyWithCommonEncryptionCbcsOnly")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates a Streaming Policy with ClearKey encryption in commonEncryptionCenc.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var streamingPolicy = new AzureNative.Media.StreamingPolicy("streamingPolicy", new()
 *     {
 *         AccountName = "contosomedia",
 *         CommonEncryptionCenc = new AzureNative.Media.Inputs.CommonEncryptionCencArgs
 *         {
 *             ClearKeyEncryptionConfiguration = new AzureNative.Media.Inputs.ClearKeyEncryptionConfigurationArgs
 *             {
 *                 CustomKeysAcquisitionUrlTemplate = "https://contoso.com/{AlternativeMediaId}/clearkey/",
 *             },
 *             ClearTracks = new[]
 *             {
 *                 new AzureNative.Media.Inputs.TrackSelectionArgs
 *                 {
 *                     TrackSelections = new[]
 *                     {
 *                         new AzureNative.Media.Inputs.TrackPropertyConditionArgs
 *                         {
 *                             Operation = AzureNative.Media.TrackPropertyCompareOperation.Equal,
 *                             Property = AzureNative.Media.TrackPropertyType.FourCC,
 *                             Value = "hev1",
 *                         },
 *                     },
 *                 },
 *             },
 *             ContentKeys = new AzureNative.Media.Inputs.StreamingPolicyContentKeysArgs
 *             {
 *                 DefaultKey = new AzureNative.Media.Inputs.DefaultKeyArgs
 *                 {
 *                     Label = "cencDefaultKey",
 *                 },
 *             },
 *             EnabledProtocols = new AzureNative.Media.Inputs.EnabledProtocolsArgs
 *             {
 *                 Dash = true,
 *                 Download = false,
 *                 Hls = false,
 *                 SmoothStreaming = true,
 *             },
 *         },
 *         DefaultContentKeyPolicyName = "PolicyWithPlayReadyOptionAndOpenRestriction",
 *         ResourceGroupName = "contosorg",
 *         StreamingPolicyName = "UserCreatedSecureStreamingPolicyWithCommonEncryptionCencOnly",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := media.NewStreamingPolicy(ctx, "streamingPolicy", &media.StreamingPolicyArgs{
 * 			AccountName: pulumi.String("contosomedia"),
 * 			CommonEncryptionCenc: &media.CommonEncryptionCencArgs{
 * 				ClearKeyEncryptionConfiguration: &media.ClearKeyEncryptionConfigurationArgs{
 * 					CustomKeysAcquisitionUrlTemplate: pulumi.String("https://contoso.com/{AlternativeMediaId}/clearkey/"),
 * 				},
 * 				ClearTracks: media.TrackSelectionArray{
 * 					&media.TrackSelectionArgs{
 * 						TrackSelections: media.TrackPropertyConditionArray{
 * 							&media.TrackPropertyConditionArgs{
 * 								Operation: pulumi.String(media.TrackPropertyCompareOperationEqual),
 * 								Property:  pulumi.String(media.TrackPropertyTypeFourCC),
 * 								Value:     pulumi.String("hev1"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 				ContentKeys: &media.StreamingPolicyContentKeysArgs{
 * 					DefaultKey: &media.DefaultKeyArgs{
 * 						Label: pulumi.String("cencDefaultKey"),
 * 					},
 * 				},
 * 				EnabledProtocols: &media.EnabledProtocolsArgs{
 * 					Dash:            pulumi.Bool(true),
 * 					Download:        pulumi.Bool(false),
 * 					Hls:             pulumi.Bool(false),
 * 					SmoothStreaming: pulumi.Bool(true),
 * 				},
 * 			},
 * 			DefaultContentKeyPolicyName: pulumi.String("PolicyWithPlayReadyOptionAndOpenRestriction"),
 * 			ResourceGroupName:           pulumi.String("contosorg"),
 * 			StreamingPolicyName:         pulumi.String("UserCreatedSecureStreamingPolicyWithCommonEncryptionCencOnly"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.StreamingPolicy;
 * import com.pulumi.azurenative.media.StreamingPolicyArgs;
 * import com.pulumi.azurenative.media.inputs.CommonEncryptionCencArgs;
 * import com.pulumi.azurenative.media.inputs.ClearKeyEncryptionConfigurationArgs;
 * import com.pulumi.azurenative.media.inputs.StreamingPolicyContentKeysArgs;
 * import com.pulumi.azurenative.media.inputs.DefaultKeyArgs;
 * import com.pulumi.azurenative.media.inputs.EnabledProtocolsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var streamingPolicy = new StreamingPolicy("streamingPolicy", StreamingPolicyArgs.builder()
 *             .accountName("contosomedia")
 *             .commonEncryptionCenc(CommonEncryptionCencArgs.builder()
 *                 .clearKeyEncryptionConfiguration(ClearKeyEncryptionConfigurationArgs.builder()
 *                     .customKeysAcquisitionUrlTemplate("https://contoso.com/{AlternativeMediaId}/clearkey/")
 *                     .build())
 *                 .clearTracks(TrackSelectionArgs.builder()
 *                     .trackSelections(TrackPropertyConditionArgs.builder()
 *                         .operation("Equal")
 *                         .property("FourCC")
 *                         .value("hev1")
 *                         .build())
 *                     .build())
 *                 .contentKeys(StreamingPolicyContentKeysArgs.builder()
 *                     .defaultKey(DefaultKeyArgs.builder()
 *                         .label("cencDefaultKey")
 *                         .build())
 *                     .build())
 *                 .enabledProtocols(EnabledProtocolsArgs.builder()
 *                     .dash(true)
 *                     .download(false)
 *                     .hls(false)
 *                     .smoothStreaming(true)
 *                     .build())
 *                 .build())
 *             .defaultContentKeyPolicyName("PolicyWithPlayReadyOptionAndOpenRestriction")
 *             .resourceGroupName("contosorg")
 *             .streamingPolicyName("UserCreatedSecureStreamingPolicyWithCommonEncryptionCencOnly")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates a Streaming Policy with clear streaming
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var streamingPolicy = new AzureNative.Media.StreamingPolicy("streamingPolicy", new()
 *     {
 *         AccountName = "contosomedia",
 *         NoEncryption = new AzureNative.Media.Inputs.NoEncryptionArgs
 *         {
 *             EnabledProtocols = new AzureNative.Media.Inputs.EnabledProtocolsArgs
 *             {
 *                 Dash = true,
 *                 Download = true,
 *                 Hls = true,
 *                 SmoothStreaming = true,
 *             },
 *         },
 *         ResourceGroupName = "contosorg",
 *         StreamingPolicyName = "clearStreamingPolicy",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := media.NewStreamingPolicy(ctx, "streamingPolicy", &media.StreamingPolicyArgs{
 * 			AccountName: pulumi.String("contosomedia"),
 * 			NoEncryption: &media.NoEncryptionArgs{
 * 				EnabledProtocols: &media.EnabledProtocolsArgs{
 * 					Dash:            pulumi.Bool(true),
 * 					Download:        pulumi.Bool(true),
 * 					Hls:             pulumi.Bool(true),
 * 					SmoothStreaming: pulumi.Bool(true),
 * 				},
 * 			},
 * 			ResourceGroupName:   pulumi.String("contosorg"),
 * 			StreamingPolicyName: pulumi.String("clearStreamingPolicy"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.StreamingPolicy;
 * import com.pulumi.azurenative.media.StreamingPolicyArgs;
 * import com.pulumi.azurenative.media.inputs.NoEncryptionArgs;
 * import com.pulumi.azurenative.media.inputs.EnabledProtocolsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var streamingPolicy = new StreamingPolicy("streamingPolicy", StreamingPolicyArgs.builder()
 *             .accountName("contosomedia")
 *             .noEncryption(NoEncryptionArgs.builder()
 *                 .enabledProtocols(EnabledProtocolsArgs.builder()
 *                     .dash(true)
 *                     .download(true)
 *                     .hls(true)
 *                     .smoothStreaming(true)
 *                     .build())
 *                 .build())
 *             .resourceGroupName("contosorg")
 *             .streamingPolicyName("clearStreamingPolicy")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates a Streaming Policy with commonEncryptionCbcs only
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var streamingPolicy = new AzureNative.Media.StreamingPolicy("streamingPolicy", new()
 *     {
 *         AccountName = "contosomedia",
 *         CommonEncryptionCbcs = new AzureNative.Media.Inputs.CommonEncryptionCbcsArgs
 *         {
 *             ContentKeys = new AzureNative.Media.Inputs.StreamingPolicyContentKeysArgs
 *             {
 *                 DefaultKey = new AzureNative.Media.Inputs.DefaultKeyArgs
 *                 {
 *                     Label = "cbcsDefaultKey",
 *                 },
 *             },
 *             Drm = new AzureNative.Media.Inputs.CbcsDrmConfigurationArgs
 *             {
 *                 FairPlay = new AzureNative.Media.Inputs.StreamingPolicyFairPlayConfigurationArgs
 *                 {
 *                     AllowPersistentLicense = true,
 *                     CustomLicenseAcquisitionUrlTemplate = "https://contoso.com/{AssetAlternativeId}/fairplay/{ContentKeyId}",
 *                 },
 *             },
 *             EnabledProtocols = new AzureNative.Media.Inputs.EnabledProtocolsArgs
 *             {
 *                 Dash = false,
 *                 Download = false,
 *                 Hls = true,
 *                 SmoothStreaming = false,
 *             },
 *         },
 *         DefaultContentKeyPolicyName = "PolicyWithMultipleOptions",
 *         ResourceGroupName = "contosorg",
 *         StreamingPolicyName = "UserCreatedSecureStreamingPolicyWithCommonEncryptionCbcsOnly",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := media.NewStreamingPolicy(ctx, "streamingPolicy", &media.StreamingPolicyArgs{
 * 			AccountName: pulumi.String("contosomedia"),
 * 			CommonEncryptionCbcs: &media.CommonEncryptionCbcsArgs{
 * 				ContentKeys: &media.StreamingPolicyContentKeysArgs{
 * 					DefaultKey: &media.DefaultKeyArgs{
 * 						Label: pulumi.String("cbcsDefaultKey"),
 * 					},
 * 				},
 * 				Drm: &media.CbcsDrmConfigurationArgs{
 * 					FairPlay: &media.StreamingPolicyFairPlayConfigurationArgs{
 * 						AllowPersistentLicense:              pulumi.Bool(true),
 * 						CustomLicenseAcquisitionUrlTemplate: pulumi.String("https://contoso.com/{AssetAlternativeId}/fairplay/{ContentKeyId}"),
 * 					},
 * 				},
 * 				EnabledProtocols: &media.EnabledProtocolsArgs{
 * 					Dash:            pulumi.Bool(false),
 * 					Download:        pulumi.Bool(false),
 * 					Hls:             pulumi.Bool(true),
 * 					SmoothStreaming: pulumi.Bool(false),
 * 				},
 * 			},
 * 			DefaultContentKeyPolicyName: pulumi.String("PolicyWithMultipleOptions"),
 * 			ResourceGroupName:           pulumi.String("contosorg"),
 * 			StreamingPolicyName:         pulumi.String("UserCreatedSecureStreamingPolicyWithCommonEncryptionCbcsOnly"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.StreamingPolicy;
 * import com.pulumi.azurenative.media.StreamingPolicyArgs;
 * import com.pulumi.azurenative.media.inputs.CommonEncryptionCbcsArgs;
 * import com.pulumi.azurenative.media.inputs.StreamingPolicyContentKeysArgs;
 * import com.pulumi.azurenative.media.inputs.DefaultKeyArgs;
 * import com.pulumi.azurenative.media.inputs.CbcsDrmConfigurationArgs;
 * import com.pulumi.azurenative.media.inputs.StreamingPolicyFairPlayConfigurationArgs;
 * import com.pulumi.azurenative.media.inputs.EnabledProtocolsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var streamingPolicy = new StreamingPolicy("streamingPolicy", StreamingPolicyArgs.builder()
 *             .accountName("contosomedia")
 *             .commonEncryptionCbcs(CommonEncryptionCbcsArgs.builder()
 *                 .contentKeys(StreamingPolicyContentKeysArgs.builder()
 *                     .defaultKey(DefaultKeyArgs.builder()
 *                         .label("cbcsDefaultKey")
 *                         .build())
 *                     .build())
 *                 .drm(CbcsDrmConfigurationArgs.builder()
 *                     .fairPlay(StreamingPolicyFairPlayConfigurationArgs.builder()
 *                         .allowPersistentLicense(true)
 *                         .customLicenseAcquisitionUrlTemplate("https://contoso.com/{AssetAlternativeId}/fairplay/{ContentKeyId}")
 *                         .build())
 *                     .build())
 *                 .enabledProtocols(EnabledProtocolsArgs.builder()
 *                     .dash(false)
 *                     .download(false)
 *                     .hls(true)
 *                     .smoothStreaming(false)
 *                     .build())
 *                 .build())
 *             .defaultContentKeyPolicyName("PolicyWithMultipleOptions")
 *             .resourceGroupName("contosorg")
 *             .streamingPolicyName("UserCreatedSecureStreamingPolicyWithCommonEncryptionCbcsOnly")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates a Streaming Policy with commonEncryptionCenc only
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var streamingPolicy = new AzureNative.Media.StreamingPolicy("streamingPolicy", new()
 *     {
 *         AccountName = "contosomedia",
 *         CommonEncryptionCenc = new AzureNative.Media.Inputs.CommonEncryptionCencArgs
 *         {
 *             ClearTracks = new[]
 *             {
 *                 new AzureNative.Media.Inputs.TrackSelectionArgs
 *                 {
 *                     TrackSelections = new[]
 *                     {
 *                         new AzureNative.Media.Inputs.TrackPropertyConditionArgs
 *                         {
 *                             Operation = AzureNative.Media.TrackPropertyCompareOperation.Equal,
 *                             Property = AzureNative.Media.TrackPropertyType.FourCC,
 *                             Value = "hev1",
 *                         },
 *                     },
 *                 },
 *             },
 *             ContentKeys = new AzureNative.Media.Inputs.StreamingPolicyContentKeysArgs
 *             {
 *                 DefaultKey = new AzureNative.Media.Inputs.DefaultKeyArgs
 *                 {
 *                     Label = "cencDefaultKey",
 *                 },
 *             },
 *             Drm = new AzureNative.Media.Inputs.CencDrmConfigurationArgs
 *             {
 *                 PlayReady = new AzureNative.Media.Inputs.StreamingPolicyPlayReadyConfigurationArgs
 *                 {
 *                     CustomLicenseAcquisitionUrlTemplate = "https://contoso.com/{AssetAlternativeId}/playready/{ContentKeyId}",
 *                     PlayReadyCustomAttributes = "PlayReady CustomAttributes",
 *                 },
 *                 Widevine = new AzureNative.Media.Inputs.StreamingPolicyWidevineConfigurationArgs
 *                 {
 *                     CustomLicenseAcquisitionUrlTemplate = "https://contoso.com/{AssetAlternativeId}/widevine/{ContentKeyId",
 *                 },
 *             },
 *             EnabledProtocols = new AzureNative.Media.Inputs.EnabledProtocolsArgs
 *             {
 *                 Dash = true,
 *                 Download = false,
 *                 Hls = false,
 *                 SmoothStreaming = true,
 *             },
 *         },
 *         DefaultContentKeyPolicyName = "PolicyWithPlayReadyOptionAndOpenRestriction",
 *         ResourceGroupName = "contosorg",
 *         StreamingPolicyName = "UserCreatedSecureStreamingPolicyWithCommonEncryptionCencOnly",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := media.NewStreamingPolicy(ctx, "streamingPolicy", &media.StreamingPolicyArgs{
 * 			AccountName: pulumi.String("contosomedia"),
 * 			CommonEncryptionCenc: &media.CommonEncryptionCencArgs{
 * 				ClearTracks: media.TrackSelectionArray{
 * 					&media.TrackSelectionArgs{
 * 						TrackSelections: media.TrackPropertyConditionArray{
 * 							&media.TrackPropertyConditionArgs{
 * 								Operation: pulumi.String(media.TrackPropertyCompareOperationEqual),
 * 								Property:  pulumi.String(media.TrackPropertyTypeFourCC),
 * 								Value:     pulumi.String("hev1"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 				ContentKeys: &media.StreamingPolicyContentKeysArgs{
 * 					DefaultKey: &media.DefaultKeyArgs{
 * 						Label: pulumi.String("cencDefaultKey"),
 * 					},
 * 				},
 * 				Drm: &media.CencDrmConfigurationArgs{
 * 					PlayReady: &media.StreamingPolicyPlayReadyConfigurationArgs{
 * 						CustomLicenseAcquisitionUrlTemplate: pulumi.String("https://contoso.com/{AssetAlternativeId}/playready/{ContentKeyId}"),
 * 						PlayReadyCustomAttributes:           pulumi.String("PlayReady CustomAttributes"),
 * 					},
 * 					Widevine: &media.StreamingPolicyWidevineConfigurationArgs{
 * 						CustomLicenseAcquisitionUrlTemplate: pulumi.String("https://contoso.com/{AssetAlternativeId}/widevine/{ContentKeyId"),
 * 					},
 * 				},
 * 				EnabledProtocols: &media.EnabledProtocolsArgs{
 * 					Dash:            pulumi.Bool(true),
 * 					Download:        pulumi.Bool(false),
 * 					Hls:             pulumi.Bool(false),
 * 					SmoothStreaming: pulumi.Bool(true),
 * 				},
 * 			},
 * 			DefaultContentKeyPolicyName: pulumi.String("PolicyWithPlayReadyOptionAndOpenRestriction"),
 * 			ResourceGroupName:           pulumi.String("contosorg"),
 * 			StreamingPolicyName:         pulumi.String("UserCreatedSecureStreamingPolicyWithCommonEncryptionCencOnly"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.StreamingPolicy;
 * import com.pulumi.azurenative.media.StreamingPolicyArgs;
 * import com.pulumi.azurenative.media.inputs.CommonEncryptionCencArgs;
 * import com.pulumi.azurenative.media.inputs.StreamingPolicyContentKeysArgs;
 * import com.pulumi.azurenative.media.inputs.DefaultKeyArgs;
 * import com.pulumi.azurenative.media.inputs.CencDrmConfigurationArgs;
 * import com.pulumi.azurenative.media.inputs.StreamingPolicyPlayReadyConfigurationArgs;
 * import com.pulumi.azurenative.media.inputs.StreamingPolicyWidevineConfigurationArgs;
 * import com.pulumi.azurenative.media.inputs.EnabledProtocolsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var streamingPolicy = new StreamingPolicy("streamingPolicy", StreamingPolicyArgs.builder()
 *             .accountName("contosomedia")
 *             .commonEncryptionCenc(CommonEncryptionCencArgs.builder()
 *                 .clearTracks(TrackSelectionArgs.builder()
 *                     .trackSelections(TrackPropertyConditionArgs.builder()
 *                         .operation("Equal")
 *                         .property("FourCC")
 *                         .value("hev1")
 *                         .build())
 *                     .build())
 *                 .contentKeys(StreamingPolicyContentKeysArgs.builder()
 *                     .defaultKey(DefaultKeyArgs.builder()
 *                         .label("cencDefaultKey")
 *                         .build())
 *                     .build())
 *                 .drm(CencDrmConfigurationArgs.builder()
 *                     .playReady(StreamingPolicyPlayReadyConfigurationArgs.builder()
 *                         .customLicenseAcquisitionUrlTemplate("https://contoso.com/{AssetAlternativeId}/playready/{ContentKeyId}")
 *                         .playReadyCustomAttributes("PlayReady CustomAttributes")
 *                         .build())
 *                     .widevine(StreamingPolicyWidevineConfigurationArgs.builder()
 *                         .customLicenseAcquisitionUrlTemplate("https://contoso.com/{AssetAlternativeId}/widevine/{ContentKeyId")
 *                         .build())
 *                     .build())
 *                 .enabledProtocols(EnabledProtocolsArgs.builder()
 *                     .dash(true)
 *                     .download(false)
 *                     .hls(false)
 *                     .smoothStreaming(true)
 *                     .build())
 *                 .build())
 *             .defaultContentKeyPolicyName("PolicyWithPlayReadyOptionAndOpenRestriction")
 *             .resourceGroupName("contosorg")
 *             .streamingPolicyName("UserCreatedSecureStreamingPolicyWithCommonEncryptionCencOnly")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates a Streaming Policy with envelopeEncryption only
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var streamingPolicy = new AzureNative.Media.StreamingPolicy("streamingPolicy", new()
 *     {
 *         AccountName = "contosomedia",
 *         DefaultContentKeyPolicyName = "PolicyWithClearKeyOptionAndTokenRestriction",
 *         EnvelopeEncryption = new AzureNative.Media.Inputs.EnvelopeEncryptionArgs
 *         {
 *             ContentKeys = new AzureNative.Media.Inputs.StreamingPolicyContentKeysArgs
 *             {
 *                 DefaultKey = new AzureNative.Media.Inputs.DefaultKeyArgs
 *                 {
 *                     Label = "aesDefaultKey",
 *                 },
 *             },
 *             CustomKeyAcquisitionUrlTemplate = "https://contoso.com/{AssetAlternativeId}/envelope/{ContentKeyId}",
 *             EnabledProtocols = new AzureNative.Media.Inputs.EnabledProtocolsArgs
 *             {
 *                 Dash = true,
 *                 Download = false,
 *                 Hls = true,
 *                 SmoothStreaming = true,
 *             },
 *         },
 *         ResourceGroupName = "contosorg",
 *         StreamingPolicyName = "UserCreatedSecureStreamingPolicyWithEnvelopeEncryptionOnly",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := media.NewStreamingPolicy(ctx, "streamingPolicy", &media.StreamingPolicyArgs{
 * 			AccountName:                 pulumi.String("contosomedia"),
 * 			DefaultContentKeyPolicyName: pulumi.String("PolicyWithClearKeyOptionAndTokenRestriction"),
 * 			EnvelopeEncryption: &media.EnvelopeEncryptionArgs{
 * 				ContentKeys: &media.StreamingPolicyContentKeysArgs{
 * 					DefaultKey: &media.DefaultKeyArgs{
 * 						Label: pulumi.String("aesDefaultKey"),
 * 					},
 * 				},
 * 				CustomKeyAcquisitionUrlTemplate: pulumi.String("https://contoso.com/{AssetAlternativeId}/envelope/{ContentKeyId}"),
 * 				EnabledProtocols: &media.EnabledProtocolsArgs{
 * 					Dash:            pulumi.Bool(true),
 * 					Download:        pulumi.Bool(false),
 * 					Hls:             pulumi.Bool(true),
 * 					SmoothStreaming: pulumi.Bool(true),
 * 				},
 * 			},
 * 			ResourceGroupName:   pulumi.String("contosorg"),
 * 			StreamingPolicyName: pulumi.String("UserCreatedSecureStreamingPolicyWithEnvelopeEncryptionOnly"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.StreamingPolicy;
 * import com.pulumi.azurenative.media.StreamingPolicyArgs;
 * import com.pulumi.azurenative.media.inputs.EnvelopeEncryptionArgs;
 * import com.pulumi.azurenative.media.inputs.StreamingPolicyContentKeysArgs;
 * import com.pulumi.azurenative.media.inputs.DefaultKeyArgs;
 * import com.pulumi.azurenative.media.inputs.EnabledProtocolsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var streamingPolicy = new StreamingPolicy("streamingPolicy", StreamingPolicyArgs.builder()
 *             .accountName("contosomedia")
 *             .defaultContentKeyPolicyName("PolicyWithClearKeyOptionAndTokenRestriction")
 *             .envelopeEncryption(EnvelopeEncryptionArgs.builder()
 *                 .contentKeys(StreamingPolicyContentKeysArgs.builder()
 *                     .defaultKey(DefaultKeyArgs.builder()
 *                         .label("aesDefaultKey")
 *                         .build())
 *                     .build())
 *                 .customKeyAcquisitionUrlTemplate("https://contoso.com/{AssetAlternativeId}/envelope/{ContentKeyId}")
 *                 .enabledProtocols(EnabledProtocolsArgs.builder()
 *                     .dash(true)
 *                     .download(false)
 *                     .hls(true)
 *                     .smoothStreaming(true)
 *                     .build())
 *                 .build())
 *             .resourceGroupName("contosorg")
 *             .streamingPolicyName("UserCreatedSecureStreamingPolicyWithEnvelopeEncryptionOnly")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates a Streaming Policy with secure streaming
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var streamingPolicy = new AzureNative.Media.StreamingPolicy("streamingPolicy", new()
 *     {
 *         AccountName = "contosomedia",
 *         CommonEncryptionCbcs = new AzureNative.Media.Inputs.CommonEncryptionCbcsArgs
 *         {
 *             ContentKeys = new AzureNative.Media.Inputs.StreamingPolicyContentKeysArgs
 *             {
 *                 DefaultKey = new AzureNative.Media.Inputs.DefaultKeyArgs
 *                 {
 *                     Label = "cbcsDefaultKey",
 *                 },
 *             },
 *             Drm = new AzureNative.Media.Inputs.CbcsDrmConfigurationArgs
 *             {
 *                 FairPlay = new AzureNative.Media.Inputs.StreamingPolicyFairPlayConfigurationArgs
 *                 {
 *                     AllowPersistentLicense = true,
 *                     CustomLicenseAcquisitionUrlTemplate = "https://contoso.com/{AssetAlternativeId}/fairplay/{ContentKeyId}",
 *                 },
 *             },
 *             EnabledProtocols = new AzureNative.Media.Inputs.EnabledProtocolsArgs
 *             {
 *                 Dash = false,
 *                 Download = false,
 *                 Hls = true,
 *                 SmoothStreaming = false,
 *             },
 *         },
 *         CommonEncryptionCenc = new AzureNative.Media.Inputs.CommonEncryptionCencArgs
 *         {
 *             ClearTracks = new[]
 *             {
 *                 new AzureNative.Media.Inputs.TrackSelectionArgs
 *                 {
 *                     TrackSelections = new[]
 *                     {
 *                         new AzureNative.Media.Inputs.TrackPropertyConditionArgs
 *                         {
 *                             Operation = AzureNative.Media.TrackPropertyCompareOperation.Equal,
 *                             Property = AzureNative.Media.TrackPropertyType.FourCC,
 *                             Value = "hev1",
 *                         },
 *                     },
 *                 },
 *             },
 *             ContentKeys = new AzureNative.Media.Inputs.StreamingPolicyContentKeysArgs
 *             {
 *                 DefaultKey = new AzureNative.Media.Inputs.DefaultKeyArgs
 *                 {
 *                     Label = "cencDefaultKey",
 *                 },
 *             },
 *             Drm = new AzureNative.Media.Inputs.CencDrmConfigurationArgs
 *             {
 *                 PlayReady = new AzureNative.Media.Inputs.StreamingPolicyPlayReadyConfigurationArgs
 *                 {
 *                     CustomLicenseAcquisitionUrlTemplate = "https://contoso.com/{AssetAlternativeId}/playready/{ContentKeyId}",
 *                     PlayReadyCustomAttributes = "PlayReady CustomAttributes",
 *                 },
 *                 Widevine = new AzureNative.Media.Inputs.StreamingPolicyWidevineConfigurationArgs
 *                 {
 *                     CustomLicenseAcquisitionUrlTemplate = "https://contoso.com/{AssetAlternativeId}/widevine/{ContentKeyId",
 *                 },
 *             },
 *             EnabledProtocols = new AzureNative.Media.Inputs.EnabledProtocolsArgs
 *             {
 *                 Dash = true,
 *                 Download = false,
 *                 Hls = false,
 *                 SmoothStreaming = true,
 *             },
 *         },
 *         DefaultContentKeyPolicyName = "PolicyWithMultipleOptions",
 *         EnvelopeEncryption = new AzureNative.Media.Inputs.EnvelopeEncryptionArgs
 *         {
 *             ContentKeys = new AzureNative.Media.Inputs.StreamingPolicyContentKeysArgs
 *             {
 *                 DefaultKey = new AzureNative.Media.Inputs.DefaultKeyArgs
 *                 {
 *                     Label = "aesDefaultKey",
 *                 },
 *             },
 *             CustomKeyAcquisitionUrlTemplate = "https://contoso.com/{AssetAlternativeId}/envelope/{ContentKeyId}",
 *             EnabledProtocols = new AzureNative.Media.Inputs.EnabledProtocolsArgs
 *             {
 *                 Dash = true,
 *                 Download = false,
 *                 Hls = true,
 *                 SmoothStreaming = true,
 *             },
 *         },
 *         ResourceGroupName = "contosorg",
 *         StreamingPolicyName = "UserCreatedSecureStreamingPolicy",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/media/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := media.NewStreamingPolicy(ctx, "streamingPolicy", &media.StreamingPolicyArgs{
 * 			AccountName: pulumi.String("contosomedia"),
 * 			CommonEncryptionCbcs: &media.CommonEncryptionCbcsArgs{
 * 				ContentKeys: &media.StreamingPolicyContentKeysArgs{
 * 					DefaultKey: &media.DefaultKeyArgs{
 * 						Label: pulumi.String("cbcsDefaultKey"),
 * 					},
 * 				},
 * 				Drm: &media.CbcsDrmConfigurationArgs{
 * 					FairPlay: &media.StreamingPolicyFairPlayConfigurationArgs{
 * 						AllowPersistentLicense:              pulumi.Bool(true),
 * 						CustomLicenseAcquisitionUrlTemplate: pulumi.String("https://contoso.com/{AssetAlternativeId}/fairplay/{ContentKeyId}"),
 * 					},
 * 				},
 * 				EnabledProtocols: &media.EnabledProtocolsArgs{
 * 					Dash:            pulumi.Bool(false),
 * 					Download:        pulumi.Bool(false),
 * 					Hls:             pulumi.Bool(true),
 * 					SmoothStreaming: pulumi.Bool(false),
 * 				},
 * 			},
 * 			CommonEncryptionCenc: &media.CommonEncryptionCencArgs{
 * 				ClearTracks: media.TrackSelectionArray{
 * 					&media.TrackSelectionArgs{
 * 						TrackSelections: media.TrackPropertyConditionArray{
 * 							&media.TrackPropertyConditionArgs{
 * 								Operation: pulumi.String(media.TrackPropertyCompareOperationEqual),
 * 								Property:  pulumi.String(media.TrackPropertyTypeFourCC),
 * 								Value:     pulumi.String("hev1"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 				ContentKeys: &media.StreamingPolicyContentKeysArgs{
 * 					DefaultKey: &media.DefaultKeyArgs{
 * 						Label: pulumi.String("cencDefaultKey"),
 * 					},
 * 				},
 * 				Drm: &media.CencDrmConfigurationArgs{
 * 					PlayReady: &media.StreamingPolicyPlayReadyConfigurationArgs{
 * 						CustomLicenseAcquisitionUrlTemplate: pulumi.String("https://contoso.com/{AssetAlternativeId}/playready/{ContentKeyId}"),
 * 						PlayReadyCustomAttributes:           pulumi.String("PlayReady CustomAttributes"),
 * 					},
 * 					Widevine: &media.StreamingPolicyWidevineConfigurationArgs{
 * 						CustomLicenseAcquisitionUrlTemplate: pulumi.String("https://contoso.com/{AssetAlternativeId}/widevine/{ContentKeyId"),
 * 					},
 * 				},
 * 				EnabledProtocols: &media.EnabledProtocolsArgs{
 * 					Dash:            pulumi.Bool(true),
 * 					Download:        pulumi.Bool(false),
 * 					Hls:             pulumi.Bool(false),
 * 					SmoothStreaming: pulumi.Bool(true),
 * 				},
 * 			},
 * 			DefaultContentKeyPolicyName: pulumi.String("PolicyWithMultipleOptions"),
 * 			EnvelopeEncryption: &media.EnvelopeEncryptionArgs{
 * 				ContentKeys: &media.StreamingPolicyContentKeysArgs{
 * 					DefaultKey: &media.DefaultKeyArgs{
 * 						Label: pulumi.String("aesDefaultKey"),
 * 					},
 * 				},
 * 				CustomKeyAcquisitionUrlTemplate: pulumi.String("https://contoso.com/{AssetAlternativeId}/envelope/{ContentKeyId}"),
 * 				EnabledProtocols: &media.EnabledProtocolsArgs{
 * 					Dash:            pulumi.Bool(true),
 * 					Download:        pulumi.Bool(false),
 * 					Hls:             pulumi.Bool(true),
 * 					SmoothStreaming: pulumi.Bool(true),
 * 				},
 * 			},
 * 			ResourceGroupName:   pulumi.String("contosorg"),
 * 			StreamingPolicyName: pulumi.String("UserCreatedSecureStreamingPolicy"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.media.StreamingPolicy;
 * import com.pulumi.azurenative.media.StreamingPolicyArgs;
 * import com.pulumi.azurenative.media.inputs.CommonEncryptionCbcsArgs;
 * import com.pulumi.azurenative.media.inputs.StreamingPolicyContentKeysArgs;
 * import com.pulumi.azurenative.media.inputs.DefaultKeyArgs;
 * import com.pulumi.azurenative.media.inputs.CbcsDrmConfigurationArgs;
 * import com.pulumi.azurenative.media.inputs.StreamingPolicyFairPlayConfigurationArgs;
 * import com.pulumi.azurenative.media.inputs.EnabledProtocolsArgs;
 * import com.pulumi.azurenative.media.inputs.CommonEncryptionCencArgs;
 * import com.pulumi.azurenative.media.inputs.CencDrmConfigurationArgs;
 * import com.pulumi.azurenative.media.inputs.StreamingPolicyPlayReadyConfigurationArgs;
 * import com.pulumi.azurenative.media.inputs.StreamingPolicyWidevineConfigurationArgs;
 * import com.pulumi.azurenative.media.inputs.EnvelopeEncryptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var streamingPolicy = new StreamingPolicy("streamingPolicy", StreamingPolicyArgs.builder()
 *             .accountName("contosomedia")
 *             .commonEncryptionCbcs(CommonEncryptionCbcsArgs.builder()
 *                 .contentKeys(StreamingPolicyContentKeysArgs.builder()
 *                     .defaultKey(DefaultKeyArgs.builder()
 *                         .label("cbcsDefaultKey")
 *                         .build())
 *                     .build())
 *                 .drm(CbcsDrmConfigurationArgs.builder()
 *                     .fairPlay(StreamingPolicyFairPlayConfigurationArgs.builder()
 *                         .allowPersistentLicense(true)
 *                         .customLicenseAcquisitionUrlTemplate("https://contoso.com/{AssetAlternativeId}/fairplay/{ContentKeyId}")
 *                         .build())
 *                     .build())
 *                 .enabledProtocols(EnabledProtocolsArgs.builder()
 *                     .dash(false)
 *                     .download(false)
 *                     .hls(true)
 *                     .smoothStreaming(false)
 *                     .build())
 *                 .build())
 *             .commonEncryptionCenc(CommonEncryptionCencArgs.builder()
 *                 .clearTracks(TrackSelectionArgs.builder()
 *                     .trackSelections(TrackPropertyConditionArgs.builder()
 *                         .operation("Equal")
 *                         .property("FourCC")
 *                         .value("hev1")
 *                         .build())
 *                     .build())
 *                 .contentKeys(StreamingPolicyContentKeysArgs.builder()
 *                     .defaultKey(DefaultKeyArgs.builder()
 *                         .label("cencDefaultKey")
 *                         .build())
 *                     .build())
 *                 .drm(CencDrmConfigurationArgs.builder()
 *                     .playReady(StreamingPolicyPlayReadyConfigurationArgs.builder()
 *                         .customLicenseAcquisitionUrlTemplate("https://contoso.com/{AssetAlternativeId}/playready/{ContentKeyId}")
 *                         .playReadyCustomAttributes("PlayReady CustomAttributes")
 *                         .build())
 *                     .widevine(StreamingPolicyWidevineConfigurationArgs.builder()
 *                         .customLicenseAcquisitionUrlTemplate("https://contoso.com/{AssetAlternativeId}/widevine/{ContentKeyId")
 *                         .build())
 *                     .build())
 *                 .enabledProtocols(EnabledProtocolsArgs.builder()
 *                     .dash(true)
 *                     .download(false)
 *                     .hls(false)
 *                     .smoothStreaming(true)
 *                     .build())
 *                 .build())
 *             .defaultContentKeyPolicyName("PolicyWithMultipleOptions")
 *             .envelopeEncryption(EnvelopeEncryptionArgs.builder()
 *                 .contentKeys(StreamingPolicyContentKeysArgs.builder()
 *                     .defaultKey(DefaultKeyArgs.builder()
 *                         .label("aesDefaultKey")
 *                         .build())
 *                     .build())
 *                 .customKeyAcquisitionUrlTemplate("https://contoso.com/{AssetAlternativeId}/envelope/{ContentKeyId}")
 *                 .enabledProtocols(EnabledProtocolsArgs.builder()
 *                     .dash(true)
 *                     .download(false)
 *                     .hls(true)
 *                     .smoothStreaming(true)
 *                     .build())
 *                 .build())
 *             .resourceGroupName("contosorg")
 *             .streamingPolicyName("UserCreatedSecureStreamingPolicy")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:media:StreamingPolicy UserCreatedSecureStreamingPolicy /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/mediaServices/{accountName}/streamingPolicies/{streamingPolicyName}
 * ```
 */
public class StreamingPolicy internal constructor(
    override val javaResource: com.pulumi.azurenative.media.StreamingPolicy,
) : KotlinCustomResource(javaResource, StreamingPolicyMapper) {
    /**
     * Configuration of CommonEncryptionCbcs
     */
    public val commonEncryptionCbcs: Output<CommonEncryptionCbcsResponse>?
        get() = javaResource.commonEncryptionCbcs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> commonEncryptionCbcsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Configuration of CommonEncryptionCenc
     */
    public val commonEncryptionCenc: Output<CommonEncryptionCencResponse>?
        get() = javaResource.commonEncryptionCenc().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> commonEncryptionCencResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Creation time of Streaming Policy
     */
    public val created: Output<String>
        get() = javaResource.created().applyValue({ args0 -> args0 })

    /**
     * Default ContentKey used by current Streaming Policy
     */
    public val defaultContentKeyPolicyName: Output<String>?
        get() = javaResource.defaultContentKeyPolicyName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configuration of EnvelopeEncryption
     */
    public val envelopeEncryption: Output<EnvelopeEncryptionResponse>?
        get() = javaResource.envelopeEncryption().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> envelopeEncryptionResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Configurations of NoEncryption
     */
    public val noEncryption: Output<NoEncryptionResponse>?
        get() = javaResource.noEncryption().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    noEncryptionResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The system metadata relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object StreamingPolicyMapper : ResourceMapper<StreamingPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.media.StreamingPolicy::class == javaResource::class

    override fun map(javaResource: Resource): StreamingPolicy = StreamingPolicy(
        javaResource as
            com.pulumi.azurenative.media.StreamingPolicy,
    )
}

/**
 * @see [StreamingPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StreamingPolicy].
 */
public suspend fun streamingPolicy(
    name: String,
    block: suspend StreamingPolicyResourceBuilder.() -> Unit,
): StreamingPolicy {
    val builder = StreamingPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StreamingPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun streamingPolicy(name: String): StreamingPolicy {
    val builder = StreamingPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
