@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The encoding profile to be used when encoding audio with AAC.
 */
public enum class AacAudioProfile(
    public val javaValue: com.pulumi.azurenative.media.enums.AacAudioProfile,
) : ConvertibleToJava<com.pulumi.azurenative.media.enums.AacAudioProfile> {
    /**
     * Specifies that the output audio is to be encoded into AAC Low Complexity profile (AAC-LC).
     */
    AacLc(com.pulumi.azurenative.media.enums.AacAudioProfile.AacLc),

    /**
     * Specifies that the output audio is to be encoded into HE-AAC v1 profile.
     */
    HeAacV1(com.pulumi.azurenative.media.enums.AacAudioProfile.HeAacV1),

    /**
     * Specifies that the output audio is to be encoded into HE-AAC v2 profile.
     */
    HeAacV2(com.pulumi.azurenative.media.enums.AacAudioProfile.HeAacV2),
    ;

    override fun toJava(): com.pulumi.azurenative.media.enums.AacAudioProfile = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.enums.AacAudioProfile): AacAudioProfile = AacAudioProfile.values().first { it.javaValue == javaType }
    }
}
