@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the maximum resolution at which your video is analyzed. The default behavior is "SourceResolution," which will keep the input video at its original resolution when analyzed. Using "StandardDefinition" will resize input videos to standard definition while preserving the appropriate aspect ratio. It will only resize if the video is of higher resolution. For example, a 1920x1080 input would be scaled to 640x360 before processing. Switching to "StandardDefinition" will reduce the time it takes to process high resolution video. It may also reduce the cost of using this component (see https://azure.microsoft.com/en-us/pricing/details/media-services/#analytics for details). However, faces that end up being too small in the resized video may not be detected.
 */
public enum class AnalysisResolution(
    public val javaValue: com.pulumi.azurenative.media.enums.AnalysisResolution,
) : ConvertibleToJava<com.pulumi.azurenative.media.enums.AnalysisResolution> {
    SourceResolution(com.pulumi.azurenative.media.enums.AnalysisResolution.SourceResolution),
    StandardDefinition(com.pulumi.azurenative.media.enums.AnalysisResolution.StandardDefinition),
    ;

    override fun toJava(): com.pulumi.azurenative.media.enums.AnalysisResolution = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.enums.AnalysisResolution): AnalysisResolution = AnalysisResolution.values().first { it.javaValue == javaType }
    }
}
