@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of AttributeFilter to apply to the TrackAttribute in order to select the tracks.
 */
public enum class AttributeFilter(
    public val javaValue: com.pulumi.azurenative.media.enums.AttributeFilter,
) : ConvertibleToJava<com.pulumi.azurenative.media.enums.AttributeFilter> {
    /**
     * All tracks will be included.
     */
    All(com.pulumi.azurenative.media.enums.AttributeFilter.All),

    /**
     * The first track will be included when the attribute is sorted in descending order.  Generally used to select the largest bitrate.
     */
    Top(com.pulumi.azurenative.media.enums.AttributeFilter.Top),

    /**
     * The first track will be included when the attribute is sorted in ascending order.  Generally used to select the smallest bitrate.
     */
    Bottom(com.pulumi.azurenative.media.enums.AttributeFilter.Bottom),

    /**
     * Any tracks that have an attribute equal to the value given will be included.
     */
    ValueEquals(com.pulumi.azurenative.media.enums.AttributeFilter.ValueEquals),
    ;

    override fun toJava(): com.pulumi.azurenative.media.enums.AttributeFilter = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.enums.AttributeFilter): AttributeFilter = AttributeFilter.values().first { it.javaValue == javaType }
    }
}
