@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The PlayReady content type.
 */
public enum class ContentKeyPolicyPlayReadyContentType(
    public val javaValue: com.pulumi.azurenative.media.enums.ContentKeyPolicyPlayReadyContentType,
) : ConvertibleToJava<com.pulumi.azurenative.media.enums.ContentKeyPolicyPlayReadyContentType> {
    /**
     * Represents a ContentKeyPolicyPlayReadyContentType that is unavailable in current API version.
     */
    Unknown(com.pulumi.azurenative.media.enums.ContentKeyPolicyPlayReadyContentType.Unknown),

    /**
     * Unspecified content type.
     */
    Unspecified(com.pulumi.azurenative.media.enums.ContentKeyPolicyPlayReadyContentType.Unspecified),

    /**
     * Ultraviolet download content type.
     */
    UltraVioletDownload(com.pulumi.azurenative.media.enums.ContentKeyPolicyPlayReadyContentType.UltraVioletDownload),

    /**
     * Ultraviolet streaming content type.
     */
    UltraVioletStreaming(com.pulumi.azurenative.media.enums.ContentKeyPolicyPlayReadyContentType.UltraVioletStreaming),
    ;

    override fun toJava(): com.pulumi.azurenative.media.enums.ContentKeyPolicyPlayReadyContentType =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.enums.ContentKeyPolicyPlayReadyContentType): ContentKeyPolicyPlayReadyContentType =
            ContentKeyPolicyPlayReadyContentType.values().first { it.javaValue == javaType }
    }
}
