@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The license type.
 */
public enum class ContentKeyPolicyPlayReadyLicenseType(
    public val javaValue: com.pulumi.azurenative.media.enums.ContentKeyPolicyPlayReadyLicenseType,
) : ConvertibleToJava<com.pulumi.azurenative.media.enums.ContentKeyPolicyPlayReadyLicenseType> {
    /**
     * Represents a ContentKeyPolicyPlayReadyLicenseType that is unavailable in current API version.
     */
    Unknown(com.pulumi.azurenative.media.enums.ContentKeyPolicyPlayReadyLicenseType.Unknown),

    /**
     * Non persistent license.
     */
    NonPersistent(com.pulumi.azurenative.media.enums.ContentKeyPolicyPlayReadyLicenseType.NonPersistent),

    /**
     * Persistent license. Allows offline playback.
     */
    Persistent(com.pulumi.azurenative.media.enums.ContentKeyPolicyPlayReadyLicenseType.Persistent),
    ;

    override fun toJava(): com.pulumi.azurenative.media.enums.ContentKeyPolicyPlayReadyLicenseType =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.enums.ContentKeyPolicyPlayReadyLicenseType): ContentKeyPolicyPlayReadyLicenseType =
            ContentKeyPolicyPlayReadyLicenseType.values().first { it.javaValue == javaType }
    }
}
