@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of token.
 */
public enum class ContentKeyPolicyRestrictionTokenType(
    public val javaValue: com.pulumi.azurenative.media.enums.ContentKeyPolicyRestrictionTokenType,
) : ConvertibleToJava<com.pulumi.azurenative.media.enums.ContentKeyPolicyRestrictionTokenType> {
    /**
     * Represents a ContentKeyPolicyRestrictionTokenType that is unavailable in current API version.
     */
    Unknown(com.pulumi.azurenative.media.enums.ContentKeyPolicyRestrictionTokenType.Unknown),

    /**
     * Simple Web Token.
     */
    Swt(com.pulumi.azurenative.media.enums.ContentKeyPolicyRestrictionTokenType.Swt),

    /**
     * JSON Web Token.
     */
    Jwt(com.pulumi.azurenative.media.enums.ContentKeyPolicyRestrictionTokenType.Jwt),
    ;

    override fun toJava(): com.pulumi.azurenative.media.enums.ContentKeyPolicyRestrictionTokenType =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.enums.ContentKeyPolicyRestrictionTokenType): ContentKeyPolicyRestrictionTokenType =
            ContentKeyPolicyRestrictionTokenType.values().first { it.javaValue == javaType }
    }
}
