@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The video rate control mode
 */
public enum class H264RateControlMode(
    public val javaValue: com.pulumi.azurenative.media.enums.H264RateControlMode,
) : ConvertibleToJava<com.pulumi.azurenative.media.enums.H264RateControlMode> {
    /**
     * Average Bitrate (ABR) mode that hits the target bitrate: Default mode.
     */
    ABR(com.pulumi.azurenative.media.enums.H264RateControlMode.ABR),

    /**
     * Constant Bitrate (CBR) mode that tightens bitrate variations around target bitrate.
     */
    CBR(com.pulumi.azurenative.media.enums.H264RateControlMode.CBR),

    /**
     * Constant Rate Factor (CRF) mode that targets at constant subjective quality.
     */
    CRF(com.pulumi.azurenative.media.enums.H264RateControlMode.CRF),
    ;

    override fun toJava(): com.pulumi.azurenative.media.enums.H264RateControlMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.enums.H264RateControlMode): H264RateControlMode = H264RateControlMode.values().first { it.javaValue == javaType }
    }
}
