@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The input protocol for the live event. This is specified at creation time and cannot be updated.
 */
public enum class LiveEventInputProtocol(
    public val javaValue: com.pulumi.azurenative.media.enums.LiveEventInputProtocol,
) : ConvertibleToJava<com.pulumi.azurenative.media.enums.LiveEventInputProtocol> {
    /**
     * Smooth Streaming input will be sent by the contribution encoder to the live event.
     */
    FragmentedMP4(com.pulumi.azurenative.media.enums.LiveEventInputProtocol.FragmentedMP4),

    /**
     * RTMP input will be sent by the contribution encoder to the live event.
     */
    RTMP(com.pulumi.azurenative.media.enums.LiveEventInputProtocol.RTMP),
    ;

    override fun toJava(): com.pulumi.azurenative.media.enums.LiveEventInputProtocol = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.enums.LiveEventInputProtocol): LiveEventInputProtocol = LiveEventInputProtocol.values().first { it.javaValue == javaType }
    }
}
