@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of the storage account.
 */
public enum class StorageAccountType(
    public val javaValue: com.pulumi.azurenative.media.enums.StorageAccountType,
) : ConvertibleToJava<com.pulumi.azurenative.media.enums.StorageAccountType> {
    /**
     * The primary storage account for the Media Services account.
     */
    Primary(com.pulumi.azurenative.media.enums.StorageAccountType.Primary),

    /**
     * A secondary storage account for the Media Services account.
     */
    Secondary(com.pulumi.azurenative.media.enums.StorageAccountType.Secondary),
    ;

    override fun toJava(): com.pulumi.azurenative.media.enums.StorageAccountType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.enums.StorageAccountType): StorageAccountType = StorageAccountType.values().first { it.javaValue == javaType }
    }
}
