@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

public enum class StreamOptionsFlag(
    public val javaValue: com.pulumi.azurenative.media.enums.StreamOptionsFlag,
) : ConvertibleToJava<com.pulumi.azurenative.media.enums.StreamOptionsFlag> {
    /**
     * Live streaming with no special latency optimizations.
     */
    Default(com.pulumi.azurenative.media.enums.StreamOptionsFlag.Default),

    /**
     * The live event provides lower end to end latency by reducing its internal buffers.
     */
    LowLatency(com.pulumi.azurenative.media.enums.StreamOptionsFlag.LowLatency),

    /**
     * The live event is optimized for end to end latency. This option is only available for encoding live events with RTMP input. The outputs can be streamed using HLS or DASH formats. The outputs' archive or DVR rewind length is limited to 6 hours. Use "LowLatency" stream option for all other scenarios.
     */
    LowLatencyV2(com.pulumi.azurenative.media.enums.StreamOptionsFlag.LowLatencyV2),
    ;

    override fun toJava(): com.pulumi.azurenative.media.enums.StreamOptionsFlag = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.enums.StreamOptionsFlag): StreamOptionsFlag = StreamOptionsFlag.values().first { it.javaValue == javaType }
    }
}
