@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.AacAudioArgs.builder
import com.pulumi.azurenative.media.kotlin.enums.AacAudioProfile
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes Advanced Audio Codec (AAC) audio encoding settings.
 * @property bitrate The bitrate, in bits per second, of the output encoded audio.
 * @property channels The number of channels in the audio.
 * @property label An optional label for the codec. The label can be used to control muxing behavior.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.AacAudio'.
 * @property profile The encoding profile to be used when encoding audio with AAC.
 * @property samplingRate The sampling rate to use for encoding in hertz.
 */
public data class AacAudioArgs(
    public val bitrate: Output<Int>? = null,
    public val channels: Output<Int>? = null,
    public val label: Output<String>? = null,
    public val odataType: Output<String>,
    public val profile: Output<Either<String, AacAudioProfile>>? = null,
    public val samplingRate: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.AacAudioArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.AacAudioArgs =
        com.pulumi.azurenative.media.inputs.AacAudioArgs.builder()
            .bitrate(bitrate?.applyValue({ args0 -> args0 }))
            .channels(channels?.applyValue({ args0 -> args0 }))
            .label(label?.applyValue({ args0 -> args0 }))
            .odataType(odataType.applyValue({ args0 -> args0 }))
            .profile(
                profile?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .samplingRate(samplingRate?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AacAudioArgs].
 */
@PulumiTagMarker
public class AacAudioArgsBuilder internal constructor() {
    private var bitrate: Output<Int>? = null

    private var channels: Output<Int>? = null

    private var label: Output<String>? = null

    private var odataType: Output<String>? = null

    private var profile: Output<Either<String, AacAudioProfile>>? = null

    private var samplingRate: Output<Int>? = null

    /**
     * @param value The bitrate, in bits per second, of the output encoded audio.
     */
    @JvmName("lwttqfbtckqfjnxp")
    public suspend fun bitrate(`value`: Output<Int>) {
        this.bitrate = value
    }

    /**
     * @param value The number of channels in the audio.
     */
    @JvmName("xxxtncwsencemenx")
    public suspend fun channels(`value`: Output<Int>) {
        this.channels = value
    }

    /**
     * @param value An optional label for the codec. The label can be used to control muxing behavior.
     */
    @JvmName("weifjxhuvrjygcpk")
    public suspend fun label(`value`: Output<String>) {
        this.label = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.AacAudio'.
     */
    @JvmName("duhroifvmiucpeny")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value The encoding profile to be used when encoding audio with AAC.
     */
    @JvmName("fnnxjvgkboqcdimv")
    public suspend fun profile(`value`: Output<Either<String, AacAudioProfile>>) {
        this.profile = value
    }

    /**
     * @param value The sampling rate to use for encoding in hertz.
     */
    @JvmName("tqcbjvktqyfbwumg")
    public suspend fun samplingRate(`value`: Output<Int>) {
        this.samplingRate = value
    }

    /**
     * @param value The bitrate, in bits per second, of the output encoded audio.
     */
    @JvmName("vuhmchbtjvhwfduj")
    public suspend fun bitrate(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bitrate = mapped
    }

    /**
     * @param value The number of channels in the audio.
     */
    @JvmName("kvydspefugsvyngc")
    public suspend fun channels(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.channels = mapped
    }

    /**
     * @param value An optional label for the codec. The label can be used to control muxing behavior.
     */
    @JvmName("vsnhviecibqhiusm")
    public suspend fun label(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.label = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.AacAudio'.
     */
    @JvmName("fxhoodxlgktmqmqm")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    /**
     * @param value The encoding profile to be used when encoding audio with AAC.
     */
    @JvmName("pcaeupupoxokkvgc")
    public suspend fun profile(`value`: Either<String, AacAudioProfile>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profile = mapped
    }

    /**
     * @param value The encoding profile to be used when encoding audio with AAC.
     */
    @JvmName("rkatyypgfyoocaho")
    public fun profile(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AacAudioProfile>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.profile = mapped
    }

    /**
     * @param value The encoding profile to be used when encoding audio with AAC.
     */
    @JvmName("wpvtaqqixijqxctp")
    public fun profile(`value`: AacAudioProfile) {
        val toBeMapped = Either.ofRight<String, AacAudioProfile>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.profile = mapped
    }

    /**
     * @param value The sampling rate to use for encoding in hertz.
     */
    @JvmName("bmnnpmrjmmpihhgg")
    public suspend fun samplingRate(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.samplingRate = mapped
    }

    internal fun build(): AacAudioArgs = AacAudioArgs(
        bitrate = bitrate,
        channels = channels,
        label = label,
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
        profile = profile,
        samplingRate = samplingRate,
    )
}
