@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.AccessControlArgs.builder
import com.pulumi.azurenative.media.kotlin.enums.DefaultAction
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property defaultAction The behavior for IP access control in Key Delivery.
 * @property ipAllowList The IP allow list for access control in Key Delivery. If the default action is set to 'Allow', the IP allow list must be empty.
 */
public data class AccessControlArgs(
    public val defaultAction: Output<Either<String, DefaultAction>>? = null,
    public val ipAllowList: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.AccessControlArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.AccessControlArgs =
        com.pulumi.azurenative.media.inputs.AccessControlArgs.builder()
            .defaultAction(
                defaultAction?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .ipAllowList(ipAllowList?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [AccessControlArgs].
 */
@PulumiTagMarker
public class AccessControlArgsBuilder internal constructor() {
    private var defaultAction: Output<Either<String, DefaultAction>>? = null

    private var ipAllowList: Output<List<String>>? = null

    /**
     * @param value The behavior for IP access control in Key Delivery.
     */
    @JvmName("rwfnxlfwmtimmqfj")
    public suspend fun defaultAction(`value`: Output<Either<String, DefaultAction>>) {
        this.defaultAction = value
    }

    /**
     * @param value The IP allow list for access control in Key Delivery. If the default action is set to 'Allow', the IP allow list must be empty.
     */
    @JvmName("bnhqyhbrgkmijvnv")
    public suspend fun ipAllowList(`value`: Output<List<String>>) {
        this.ipAllowList = value
    }

    @JvmName("wxlhajqrcarvpdde")
    public suspend fun ipAllowList(vararg values: Output<String>) {
        this.ipAllowList = Output.all(values.asList())
    }

    /**
     * @param values The IP allow list for access control in Key Delivery. If the default action is set to 'Allow', the IP allow list must be empty.
     */
    @JvmName("mhiymsoenijlgkjk")
    public suspend fun ipAllowList(values: List<Output<String>>) {
        this.ipAllowList = Output.all(values)
    }

    /**
     * @param value The behavior for IP access control in Key Delivery.
     */
    @JvmName("yfsvskpqleqsovap")
    public suspend fun defaultAction(`value`: Either<String, DefaultAction>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultAction = mapped
    }

    /**
     * @param value The behavior for IP access control in Key Delivery.
     */
    @JvmName("jpawerkotoyvvnww")
    public fun defaultAction(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DefaultAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultAction = mapped
    }

    /**
     * @param value The behavior for IP access control in Key Delivery.
     */
    @JvmName("ijbehassivummfas")
    public fun defaultAction(`value`: DefaultAction) {
        val toBeMapped = Either.ofRight<String, DefaultAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultAction = mapped
    }

    /**
     * @param value The IP allow list for access control in Key Delivery. If the default action is set to 'Allow', the IP allow list must be empty.
     */
    @JvmName("xrynlkgqerepmrjv")
    public suspend fun ipAllowList(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAllowList = mapped
    }

    /**
     * @param values The IP allow list for access control in Key Delivery. If the default action is set to 'Allow', the IP allow list must be empty.
     */
    @JvmName("rtjmnfqjqdlrwvcu")
    public suspend fun ipAllowList(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipAllowList = mapped
    }

    internal fun build(): AccessControlArgs = AccessControlArgs(
        defaultAction = defaultAction,
        ipAllowList = ipAllowList,
    )
}
