@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.ClearKeyEncryptionConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Class to specify ClearKey configuration of common encryption schemes in Streaming Policy
 * @property customKeysAcquisitionUrlTemplate Template for the URL of the custom service delivering content keys to end user players. Not required when using Azure Media Services for issuing licenses. The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token value is {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId.
 */
public data class ClearKeyEncryptionConfigurationArgs(
    public val customKeysAcquisitionUrlTemplate: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.ClearKeyEncryptionConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.ClearKeyEncryptionConfigurationArgs =
        com.pulumi.azurenative.media.inputs.ClearKeyEncryptionConfigurationArgs.builder()
            .customKeysAcquisitionUrlTemplate(
                customKeysAcquisitionUrlTemplate?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [ClearKeyEncryptionConfigurationArgs].
 */
@PulumiTagMarker
public class ClearKeyEncryptionConfigurationArgsBuilder internal constructor() {
    private var customKeysAcquisitionUrlTemplate: Output<String>? = null

    /**
     * @param value Template for the URL of the custom service delivering content keys to end user players. Not required when using Azure Media Services for issuing licenses. The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token value is {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId.
     */
    @JvmName("mvfvpnwieyioksvg")
    public suspend fun customKeysAcquisitionUrlTemplate(`value`: Output<String>) {
        this.customKeysAcquisitionUrlTemplate = value
    }

    /**
     * @param value Template for the URL of the custom service delivering content keys to end user players. Not required when using Azure Media Services for issuing licenses. The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token value is {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId.
     */
    @JvmName("eyuuxhdnpleexmyp")
    public suspend fun customKeysAcquisitionUrlTemplate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customKeysAcquisitionUrlTemplate = mapped
    }

    internal fun build(): ClearKeyEncryptionConfigurationArgs = ClearKeyEncryptionConfigurationArgs(
        customKeysAcquisitionUrlTemplate = customKeysAcquisitionUrlTemplate,
    )
}
