@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.ContentKeyPolicyClearKeyConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents a configuration for non-DRM keys.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.ContentKeyPolicyClearKeyConfiguration'.
 */
public data class ContentKeyPolicyClearKeyConfigurationArgs(
    public val odataType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.ContentKeyPolicyClearKeyConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.ContentKeyPolicyClearKeyConfigurationArgs =
        com.pulumi.azurenative.media.inputs.ContentKeyPolicyClearKeyConfigurationArgs.builder()
            .odataType(odataType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContentKeyPolicyClearKeyConfigurationArgs].
 */
@PulumiTagMarker
public class ContentKeyPolicyClearKeyConfigurationArgsBuilder internal constructor() {
    private var odataType: Output<String>? = null

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.ContentKeyPolicyClearKeyConfiguration'.
     */
    @JvmName("euscsdccdrosqmpl")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.ContentKeyPolicyClearKeyConfiguration'.
     */
    @JvmName("rgcuhrhvehcbksll")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    internal fun build(): ContentKeyPolicyClearKeyConfigurationArgs =
        ContentKeyPolicyClearKeyConfigurationArgs(
            odataType = odataType ?: throw PulumiNullFieldException("odataType"),
        )
}
