@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.ContentKeyPolicyRsaTokenKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies a RSA key for token validation
 * @property exponent The RSA Parameter exponent
 * @property modulus The RSA Parameter modulus
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.ContentKeyPolicyRsaTokenKey'.
 */
public data class ContentKeyPolicyRsaTokenKeyArgs(
    public val exponent: Output<String>,
    public val modulus: Output<String>,
    public val odataType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.ContentKeyPolicyRsaTokenKeyArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.ContentKeyPolicyRsaTokenKeyArgs =
        com.pulumi.azurenative.media.inputs.ContentKeyPolicyRsaTokenKeyArgs.builder()
            .exponent(exponent.applyValue({ args0 -> args0 }))
            .modulus(modulus.applyValue({ args0 -> args0 }))
            .odataType(odataType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContentKeyPolicyRsaTokenKeyArgs].
 */
@PulumiTagMarker
public class ContentKeyPolicyRsaTokenKeyArgsBuilder internal constructor() {
    private var exponent: Output<String>? = null

    private var modulus: Output<String>? = null

    private var odataType: Output<String>? = null

    /**
     * @param value The RSA Parameter exponent
     */
    @JvmName("kttakowkmufhofbk")
    public suspend fun exponent(`value`: Output<String>) {
        this.exponent = value
    }

    /**
     * @param value The RSA Parameter modulus
     */
    @JvmName("tnydilmwynobubey")
    public suspend fun modulus(`value`: Output<String>) {
        this.modulus = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.ContentKeyPolicyRsaTokenKey'.
     */
    @JvmName("khopinbdiqcquxph")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value The RSA Parameter exponent
     */
    @JvmName("myascqgfuwwktueb")
    public suspend fun exponent(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.exponent = mapped
    }

    /**
     * @param value The RSA Parameter modulus
     */
    @JvmName("lqjkwqfvirdbbvva")
    public suspend fun modulus(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.modulus = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.ContentKeyPolicyRsaTokenKey'.
     */
    @JvmName("dqjbiigukggbxwjp")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    internal fun build(): ContentKeyPolicyRsaTokenKeyArgs = ContentKeyPolicyRsaTokenKeyArgs(
        exponent = exponent ?: throw PulumiNullFieldException("exponent"),
        modulus = modulus ?: throw PulumiNullFieldException("modulus"),
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
    )
}
