@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.DashSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The DASH setting for a track.
 * @property role The role for the DASH setting.
 */
public data class DashSettingsArgs(
    public val role: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.DashSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.DashSettingsArgs =
        com.pulumi.azurenative.media.inputs.DashSettingsArgs.builder()
            .role(role?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DashSettingsArgs].
 */
@PulumiTagMarker
public class DashSettingsArgsBuilder internal constructor() {
    private var role: Output<String>? = null

    /**
     * @param value The role for the DASH setting.
     */
    @JvmName("dxrginhvxlixtoxj")
    public suspend fun role(`value`: Output<String>) {
        this.role = value
    }

    /**
     * @param value The role for the DASH setting.
     */
    @JvmName("tdofpeurkjuhnjsu")
    public suspend fun role(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.role = mapped
    }

    internal fun build(): DashSettingsArgs = DashSettingsArgs(
        role = role,
    )
}
