@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.GetLiveEventTrackIngestHeartbeatsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The Media Services account name.
 * @property liveEventName The name of the live event, maximum length is 32.
 * @property resourceGroupName The name of the resource group within the Azure subscription.
 */
public data class GetLiveEventTrackIngestHeartbeatsPlainArgs(
    public val accountName: String,
    public val liveEventName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.media.inputs.GetLiveEventTrackIngestHeartbeatsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.GetLiveEventTrackIngestHeartbeatsPlainArgs =
        com.pulumi.azurenative.media.inputs.GetLiveEventTrackIngestHeartbeatsPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .liveEventName(liveEventName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLiveEventTrackIngestHeartbeatsPlainArgs].
 */
@PulumiTagMarker
public class GetLiveEventTrackIngestHeartbeatsPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var liveEventName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The Media Services account name.
     */
    @JvmName("sikrplkkmjfbjrdq")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the live event, maximum length is 32.
     */
    @JvmName("jaluervglmptyvcu")
    public suspend fun liveEventName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.liveEventName = mapped
    }

    /**
     * @param value The name of the resource group within the Azure subscription.
     */
    @JvmName("yvcmdhafvejwacph")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetLiveEventTrackIngestHeartbeatsPlainArgs =
        GetLiveEventTrackIngestHeartbeatsPlainArgs(
            accountName = accountName ?: throw PulumiNullFieldException("accountName"),
            liveEventName = liveEventName ?: throw PulumiNullFieldException("liveEventName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
