@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.GetMediaGraphPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The Media Services account name.
 * @property mediaGraphName The Media Graph name.
 * @property resourceGroupName The name of the resource group within the Azure subscription.
 */
public data class GetMediaGraphPlainArgs(
    public val accountName: String,
    public val mediaGraphName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.GetMediaGraphPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.GetMediaGraphPlainArgs =
        com.pulumi.azurenative.media.inputs.GetMediaGraphPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .mediaGraphName(mediaGraphName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMediaGraphPlainArgs].
 */
@PulumiTagMarker
public class GetMediaGraphPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var mediaGraphName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The Media Services account name.
     */
    @JvmName("uqkslluenetplqnm")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The Media Graph name.
     */
    @JvmName("tenishauvytwisru")
    public suspend fun mediaGraphName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.mediaGraphName = mapped
    }

    /**
     * @param value The name of the resource group within the Azure subscription.
     */
    @JvmName("sfvlrynbyntbtidh")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetMediaGraphPlainArgs = GetMediaGraphPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        mediaGraphName = mediaGraphName ?: throw PulumiNullFieldException("mediaGraphName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
