@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.IPRangeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The IP address range in the CIDR scheme.
 * @property address The IP address.
 * @property name The friendly name for the IP address range.
 * @property subnetPrefixLength The subnet mask prefix length (see CIDR notation).
 */
public data class IPRangeArgs(
    public val address: Output<String>? = null,
    public val name: Output<String>? = null,
    public val subnetPrefixLength: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.IPRangeArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.IPRangeArgs =
        com.pulumi.azurenative.media.inputs.IPRangeArgs.builder()
            .address(address?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .subnetPrefixLength(subnetPrefixLength?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IPRangeArgs].
 */
@PulumiTagMarker
public class IPRangeArgsBuilder internal constructor() {
    private var address: Output<String>? = null

    private var name: Output<String>? = null

    private var subnetPrefixLength: Output<Int>? = null

    /**
     * @param value The IP address.
     */
    @JvmName("tjtfwijkytwfqedj")
    public suspend fun address(`value`: Output<String>) {
        this.address = value
    }

    /**
     * @param value The friendly name for the IP address range.
     */
    @JvmName("coxkkrjduxynfwjm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The subnet mask prefix length (see CIDR notation).
     */
    @JvmName("lrqxvsnijlwhmyso")
    public suspend fun subnetPrefixLength(`value`: Output<Int>) {
        this.subnetPrefixLength = value
    }

    /**
     * @param value The IP address.
     */
    @JvmName("aimuosccmjrhmgnr")
    public suspend fun address(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.address = mapped
    }

    /**
     * @param value The friendly name for the IP address range.
     */
    @JvmName("hguuvbredlqclcil")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The subnet mask prefix length (see CIDR notation).
     */
    @JvmName("menproubxlrtdcje")
    public suspend fun subnetPrefixLength(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetPrefixLength = mapped
    }

    internal fun build(): IPRangeArgs = IPRangeArgs(
        address = address,
        name = name,
        subnetPrefixLength = subnetPrefixLength,
    )
}
