@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.JobInputAssetArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Represents an Asset for input into a Job.
 * @property assetName The name of the input Asset.
 * @property end Defines a point on the timeline of the input media at which processing will end. Defaults to the end of the input media.
 * @property files List of files. Required for JobInputHttp. Maximum of 4000 characters each. Query strings will not be returned in service responses to prevent sensitive data exposure.
 * @property inputDefinitions Defines a list of InputDefinitions. For each InputDefinition, it defines a list of track selections and related metadata.
 * @property label A label that is assigned to a JobInputClip, that is used to satisfy a reference used in the Transform. For example, a Transform can be authored so as to take an image file with the label 'xyz' and apply it as an overlay onto the input video before it is encoded. When submitting a Job, exactly one of the JobInputs should be the image file, and it should have the label 'xyz'.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.JobInputAsset'.
 * @property start Defines a point on the timeline of the input media at which processing will start. Defaults to the beginning of the input media.
 */
public data class JobInputAssetArgs(
    public val assetName: Output<String>,
    public val end: Output<Either<AbsoluteClipTimeArgs, UtcClipTimeArgs>>? = null,
    public val files: Output<List<String>>? = null,
    public val inputDefinitions: Output<List<Any>>? = null,
    public val label: Output<String>? = null,
    public val odataType: Output<String>,
    public val start: Output<Either<AbsoluteClipTimeArgs, UtcClipTimeArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.JobInputAssetArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.JobInputAssetArgs =
        com.pulumi.azurenative.media.inputs.JobInputAssetArgs.builder()
            .assetName(assetName.applyValue({ args0 -> args0 }))
            .end(
                end?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .files(files?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .inputDefinitions(inputDefinitions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .label(label?.applyValue({ args0 -> args0 }))
            .odataType(odataType.applyValue({ args0 -> args0 }))
            .start(
                start?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [JobInputAssetArgs].
 */
@PulumiTagMarker
public class JobInputAssetArgsBuilder internal constructor() {
    private var assetName: Output<String>? = null

    private var end: Output<Either<AbsoluteClipTimeArgs, UtcClipTimeArgs>>? = null

    private var files: Output<List<String>>? = null

    private var inputDefinitions: Output<List<Any>>? = null

    private var label: Output<String>? = null

    private var odataType: Output<String>? = null

    private var start: Output<Either<AbsoluteClipTimeArgs, UtcClipTimeArgs>>? = null

    /**
     * @param value The name of the input Asset.
     */
    @JvmName("khemruxpkjjkyqcl")
    public suspend fun assetName(`value`: Output<String>) {
        this.assetName = value
    }

    /**
     * @param value Defines a point on the timeline of the input media at which processing will end. Defaults to the end of the input media.
     */
    @JvmName("jmabfwuxiulcddqc")
    public suspend fun end(`value`: Output<Either<AbsoluteClipTimeArgs, UtcClipTimeArgs>>) {
        this.end = value
    }

    /**
     * @param value List of files. Required for JobInputHttp. Maximum of 4000 characters each. Query strings will not be returned in service responses to prevent sensitive data exposure.
     */
    @JvmName("fugvuabfpubpktqb")
    public suspend fun files(`value`: Output<List<String>>) {
        this.files = value
    }

    @JvmName("kclwvtjanrrfxykk")
    public suspend fun files(vararg values: Output<String>) {
        this.files = Output.all(values.asList())
    }

    /**
     * @param values List of files. Required for JobInputHttp. Maximum of 4000 characters each. Query strings will not be returned in service responses to prevent sensitive data exposure.
     */
    @JvmName("xdikbcpgqxxqdyaj")
    public suspend fun files(values: List<Output<String>>) {
        this.files = Output.all(values)
    }

    /**
     * @param value Defines a list of InputDefinitions. For each InputDefinition, it defines a list of track selections and related metadata.
     */
    @JvmName("eefwdiqyksayrdro")
    public suspend fun inputDefinitions(`value`: Output<List<Any>>) {
        this.inputDefinitions = value
    }

    @JvmName("gsvvexwsfquybxay")
    public suspend fun inputDefinitions(vararg values: Output<Any>) {
        this.inputDefinitions = Output.all(values.asList())
    }

    /**
     * @param values Defines a list of InputDefinitions. For each InputDefinition, it defines a list of track selections and related metadata.
     */
    @JvmName("vqfvqyxilpjtimqm")
    public suspend fun inputDefinitions(values: List<Output<Any>>) {
        this.inputDefinitions = Output.all(values)
    }

    /**
     * @param value A label that is assigned to a JobInputClip, that is used to satisfy a reference used in the Transform. For example, a Transform can be authored so as to take an image file with the label 'xyz' and apply it as an overlay onto the input video before it is encoded. When submitting a Job, exactly one of the JobInputs should be the image file, and it should have the label 'xyz'.
     */
    @JvmName("cwhhpchdddedbmnn")
    public suspend fun label(`value`: Output<String>) {
        this.label = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.JobInputAsset'.
     */
    @JvmName("eqqtjunilhehjhfb")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value Defines a point on the timeline of the input media at which processing will start. Defaults to the beginning of the input media.
     */
    @JvmName("jgjvoqvixocmrytw")
    public suspend fun start(`value`: Output<Either<AbsoluteClipTimeArgs, UtcClipTimeArgs>>) {
        this.start = value
    }

    /**
     * @param value The name of the input Asset.
     */
    @JvmName("emlftbhofxkurpkn")
    public suspend fun assetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.assetName = mapped
    }

    /**
     * @param value Defines a point on the timeline of the input media at which processing will end. Defaults to the end of the input media.
     */
    @JvmName("rwiopaiiihomentw")
    public suspend fun end(`value`: Either<AbsoluteClipTimeArgs, UtcClipTimeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.end = mapped
    }

    /**
     * @param value Defines a point on the timeline of the input media at which processing will end. Defaults to the end of the input media.
     */
    @JvmName("jremjupndmcnwvsg")
    public fun end(`value`: AbsoluteClipTimeArgs) {
        val toBeMapped = Either.ofLeft<AbsoluteClipTimeArgs, UtcClipTimeArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.end = mapped
    }

    /**
     * @param value Defines a point on the timeline of the input media at which processing will end. Defaults to the end of the input media.
     */
    @JvmName("bknxoctwtgmqgubl")
    public fun end(`value`: UtcClipTimeArgs) {
        val toBeMapped = Either.ofRight<AbsoluteClipTimeArgs, UtcClipTimeArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.end = mapped
    }

    /**
     * @param value List of files. Required for JobInputHttp. Maximum of 4000 characters each. Query strings will not be returned in service responses to prevent sensitive data exposure.
     */
    @JvmName("ogjbwuhpsfbdwgxn")
    public suspend fun files(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.files = mapped
    }

    /**
     * @param values List of files. Required for JobInputHttp. Maximum of 4000 characters each. Query strings will not be returned in service responses to prevent sensitive data exposure.
     */
    @JvmName("hvtfxjoijxwsvltn")
    public suspend fun files(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.files = mapped
    }

    /**
     * @param value Defines a list of InputDefinitions. For each InputDefinition, it defines a list of track selections and related metadata.
     */
    @JvmName("uiblpkooiqvkdihl")
    public suspend fun inputDefinitions(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputDefinitions = mapped
    }

    /**
     * @param values Defines a list of InputDefinitions. For each InputDefinition, it defines a list of track selections and related metadata.
     */
    @JvmName("cydwgpgihaemaogq")
    public suspend fun inputDefinitions(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputDefinitions = mapped
    }

    /**
     * @param value A label that is assigned to a JobInputClip, that is used to satisfy a reference used in the Transform. For example, a Transform can be authored so as to take an image file with the label 'xyz' and apply it as an overlay onto the input video before it is encoded. When submitting a Job, exactly one of the JobInputs should be the image file, and it should have the label 'xyz'.
     */
    @JvmName("lnxdofeopnqskctd")
    public suspend fun label(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.label = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.JobInputAsset'.
     */
    @JvmName("ytigudhyxmotfcps")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    /**
     * @param value Defines a point on the timeline of the input media at which processing will start. Defaults to the beginning of the input media.
     */
    @JvmName("fopavrsywyubcaxb")
    public suspend fun start(`value`: Either<AbsoluteClipTimeArgs, UtcClipTimeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.start = mapped
    }

    /**
     * @param value Defines a point on the timeline of the input media at which processing will start. Defaults to the beginning of the input media.
     */
    @JvmName("nkchevjowkcnlgga")
    public fun start(`value`: AbsoluteClipTimeArgs) {
        val toBeMapped = Either.ofLeft<AbsoluteClipTimeArgs, UtcClipTimeArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.start = mapped
    }

    /**
     * @param value Defines a point on the timeline of the input media at which processing will start. Defaults to the beginning of the input media.
     */
    @JvmName("gsflcfepmbyvplfi")
    public fun start(`value`: UtcClipTimeArgs) {
        val toBeMapped = Either.ofRight<AbsoluteClipTimeArgs, UtcClipTimeArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.start = mapped
    }

    internal fun build(): JobInputAssetArgs = JobInputAssetArgs(
        assetName = assetName ?: throw PulumiNullFieldException("assetName"),
        end = end,
        files = files,
        inputDefinitions = inputDefinitions,
        label = label,
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
        start = start,
    )
}
