@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.JobInputsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes a list of inputs to a Job.
 * @property inputs List of inputs to a Job.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.JobInputs'.
 */
public data class JobInputsArgs(
    public val inputs: Output<List<Any>>? = null,
    public val odataType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.JobInputsArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.JobInputsArgs =
        com.pulumi.azurenative.media.inputs.JobInputsArgs.builder()
            .inputs(inputs?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .odataType(odataType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JobInputsArgs].
 */
@PulumiTagMarker
public class JobInputsArgsBuilder internal constructor() {
    private var inputs: Output<List<Any>>? = null

    private var odataType: Output<String>? = null

    /**
     * @param value List of inputs to a Job.
     */
    @JvmName("fnchyuitjuaermhs")
    public suspend fun inputs(`value`: Output<List<Any>>) {
        this.inputs = value
    }

    @JvmName("tkeugmamimmvaurj")
    public suspend fun inputs(vararg values: Output<Any>) {
        this.inputs = Output.all(values.asList())
    }

    /**
     * @param values List of inputs to a Job.
     */
    @JvmName("yjxyimcumldovmdi")
    public suspend fun inputs(values: List<Output<Any>>) {
        this.inputs = Output.all(values)
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.JobInputs'.
     */
    @JvmName("spitsqvayblbqveb")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value List of inputs to a Job.
     */
    @JvmName("ipexfsvtufxwfnpm")
    public suspend fun inputs(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputs = mapped
    }

    /**
     * @param values List of inputs to a Job.
     */
    @JvmName("pmfuombwobhxcmqh")
    public suspend fun inputs(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputs = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.JobInputs'.
     */
    @JvmName("pxqbkiadodqcmatu")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    internal fun build(): JobInputsArgs = JobInputsArgs(
        inputs = inputs,
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
    )
}
