@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.KeyDeliveryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property accessControl The access control properties for Key Delivery.
 */
public data class KeyDeliveryArgs(
    public val accessControl: Output<AccessControlArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.KeyDeliveryArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.KeyDeliveryArgs =
        com.pulumi.azurenative.media.inputs.KeyDeliveryArgs.builder()
            .accessControl(accessControl?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [KeyDeliveryArgs].
 */
@PulumiTagMarker
public class KeyDeliveryArgsBuilder internal constructor() {
    private var accessControl: Output<AccessControlArgs>? = null

    /**
     * @param value The access control properties for Key Delivery.
     */
    @JvmName("dqxhfhncnsraqtru")
    public suspend fun accessControl(`value`: Output<AccessControlArgs>) {
        this.accessControl = value
    }

    /**
     * @param value The access control properties for Key Delivery.
     */
    @JvmName("xgkvxitmbtamwnit")
    public suspend fun accessControl(`value`: AccessControlArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessControl = mapped
    }

    /**
     * @param argument The access control properties for Key Delivery.
     */
    @JvmName("ydonuqxrlndkhyfl")
    public suspend fun accessControl(argument: suspend AccessControlArgsBuilder.() -> Unit) {
        val toBeMapped = AccessControlArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.accessControl = mapped
    }

    internal fun build(): KeyDeliveryArgs = KeyDeliveryArgs(
        accessControl = accessControl,
    )
}
