@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.MediaGraphRtspSourceArgs.builder
import com.pulumi.azurenative.media.kotlin.enums.MediaGraphRtspTransport
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * RTSP source.
 * @property endpoint RTSP endpoint of the stream being connected to.
 * @property name Source name.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.MediaGraphRtspSource'.
 * @property transport Underlying RTSP transport. This can be used to enable or disable HTTP tunneling.
 */
public data class MediaGraphRtspSourceArgs(
    public val endpoint: Output<Either<MediaGraphClearEndpointArgs, MediaGraphTlsEndpointArgs>>,
    public val name: Output<String>,
    public val odataType: Output<String>,
    public val transport: Output<Either<String, MediaGraphRtspTransport>>,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.MediaGraphRtspSourceArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.MediaGraphRtspSourceArgs =
        com.pulumi.azurenative.media.inputs.MediaGraphRtspSourceArgs.builder()
            .endpoint(
                endpoint.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .name(name.applyValue({ args0 -> args0 }))
            .odataType(odataType.applyValue({ args0 -> args0 }))
            .transport(
                transport.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [MediaGraphRtspSourceArgs].
 */
@PulumiTagMarker
public class MediaGraphRtspSourceArgsBuilder internal constructor() {
    private var endpoint: Output<Either<MediaGraphClearEndpointArgs, MediaGraphTlsEndpointArgs>>? =
        null

    private var name: Output<String>? = null

    private var odataType: Output<String>? = null

    private var transport: Output<Either<String, MediaGraphRtspTransport>>? = null

    /**
     * @param value RTSP endpoint of the stream being connected to.
     */
    @JvmName("dvogndwvjohgjpds")
    public suspend fun endpoint(`value`: Output<Either<MediaGraphClearEndpointArgs, MediaGraphTlsEndpointArgs>>) {
        this.endpoint = value
    }

    /**
     * @param value Source name.
     */
    @JvmName("huqkejwqftdnbwun")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.MediaGraphRtspSource'.
     */
    @JvmName("uphpggfssmjijlbw")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value Underlying RTSP transport. This can be used to enable or disable HTTP tunneling.
     */
    @JvmName("eosqtgucgoijigco")
    public suspend fun transport(`value`: Output<Either<String, MediaGraphRtspTransport>>) {
        this.transport = value
    }

    /**
     * @param value RTSP endpoint of the stream being connected to.
     */
    @JvmName("covfqopfochwpwxr")
    public suspend fun endpoint(`value`: Either<MediaGraphClearEndpointArgs, MediaGraphTlsEndpointArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    /**
     * @param value RTSP endpoint of the stream being connected to.
     */
    @JvmName("vwawamwmqpmcffig")
    public fun endpoint(`value`: MediaGraphClearEndpointArgs) {
        val toBeMapped = Either.ofLeft<MediaGraphClearEndpointArgs, MediaGraphTlsEndpointArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    /**
     * @param value RTSP endpoint of the stream being connected to.
     */
    @JvmName("pgqpuwnmckcwilnb")
    public fun endpoint(`value`: MediaGraphTlsEndpointArgs) {
        val toBeMapped = Either.ofRight<MediaGraphClearEndpointArgs, MediaGraphTlsEndpointArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    /**
     * @param value Source name.
     */
    @JvmName("rkvpbjbregpptpme")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.MediaGraphRtspSource'.
     */
    @JvmName("jbknocsbqixsldpy")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    /**
     * @param value Underlying RTSP transport. This can be used to enable or disable HTTP tunneling.
     */
    @JvmName("kklgqmbwrksyqigw")
    public suspend fun transport(`value`: Either<String, MediaGraphRtspTransport>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transport = mapped
    }

    /**
     * @param value Underlying RTSP transport. This can be used to enable or disable HTTP tunneling.
     */
    @JvmName("dtdryvseksoksxxl")
    public fun transport(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MediaGraphRtspTransport>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transport = mapped
    }

    /**
     * @param value Underlying RTSP transport. This can be used to enable or disable HTTP tunneling.
     */
    @JvmName("vkyvvtjfvtdpywvi")
    public fun transport(`value`: MediaGraphRtspTransport) {
        val toBeMapped = Either.ofRight<String, MediaGraphRtspTransport>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transport = mapped
    }

    internal fun build(): MediaGraphRtspSourceArgs = MediaGraphRtspSourceArgs(
        endpoint = endpoint ?: throw PulumiNullFieldException("endpoint"),
        name = name ?: throw PulumiNullFieldException("name"),
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
        transport = transport ?: throw PulumiNullFieldException("transport"),
    )
}
