@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.PngImageArgs.builder
import com.pulumi.azurenative.media.kotlin.enums.StretchMode
import com.pulumi.azurenative.media.kotlin.enums.VideoSyncMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes the properties for producing a series of PNG images from the input video.
 * @property keyFrameInterval The distance between two key frames. The value should be non-zero in the range [0&#46;5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
 * @property label An optional label for the codec. The label can be used to control muxing behavior.
 * @property layers A collection of output PNG image layers to be produced by the encoder.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.PngImage'.
 * @property range The position relative to transform preset start time in the input video at which to stop generating thumbnails. The value can be in ISO 8601 format (For example, PT5M30S to stop at 5 minutes and 30 seconds from start time), or a frame count (For example, 300 to stop at the 300th frame from the frame at start time. If this value is 1, it means only producing one thumbnail at start time), or a relative value to the stream duration (For example, 50% to stop at half of stream duration from start time). The default value is 100%, which means to stop at the end of the stream.
 * @property start The position in the input video from where to start generating thumbnails. The value can be in ISO 8601 format (For example, PT05S to start at 5 seconds), or a frame count (For example, 10 to start at the 10th frame), or a relative value to stream duration (For example, 10% to start at 10% of stream duration). Also supports a macro {Best}, which tells the encoder to select the best thumbnail from the first few seconds of the video and will only produce one thumbnail, no matter what other settings are for Step and Range. The default value is macro {Best}.
 * @property step The intervals at which thumbnails are generated. The value can be in ISO 8601 format (For example, PT05S for one image every 5 seconds), or a frame count (For example, 30 for one image every 30 frames), or a relative value to stream duration (For example, 10% for one image every 10% of stream duration). Note: Step value will affect the first generated thumbnail, which may not be exactly the one specified at transform preset start time. This is due to the encoder, which tries to select the best thumbnail between start time and Step position from start time as the first output. As the default value is 10%, it means if stream has long duration, the first generated thumbnail might be far away from the one specified at start time. Try to select reasonable value for Step if the first thumbnail is expected close to start time, or set Range value at 1 if only one thumbnail is needed at start time.
 * @property stretchMode The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
 * @property syncMode The Video Sync Mode
 */
public data class PngImageArgs(
    public val keyFrameInterval: Output<String>? = null,
    public val label: Output<String>? = null,
    public val layers: Output<List<PngLayerArgs>>? = null,
    public val odataType: Output<String>,
    public val range: Output<String>? = null,
    public val start: Output<String>,
    public val step: Output<String>? = null,
    public val stretchMode: Output<Either<String, StretchMode>>? = null,
    public val syncMode: Output<Either<String, VideoSyncMode>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.PngImageArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.PngImageArgs =
        com.pulumi.azurenative.media.inputs.PngImageArgs.builder()
            .keyFrameInterval(keyFrameInterval?.applyValue({ args0 -> args0 }))
            .label(label?.applyValue({ args0 -> args0 }))
            .layers(layers?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .odataType(odataType.applyValue({ args0 -> args0 }))
            .range(range?.applyValue({ args0 -> args0 }))
            .start(start.applyValue({ args0 -> args0 }))
            .step(step?.applyValue({ args0 -> args0 }))
            .stretchMode(
                stretchMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .syncMode(
                syncMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [PngImageArgs].
 */
@PulumiTagMarker
public class PngImageArgsBuilder internal constructor() {
    private var keyFrameInterval: Output<String>? = null

    private var label: Output<String>? = null

    private var layers: Output<List<PngLayerArgs>>? = null

    private var odataType: Output<String>? = null

    private var range: Output<String>? = null

    private var start: Output<String>? = null

    private var step: Output<String>? = null

    private var stretchMode: Output<Either<String, StretchMode>>? = null

    private var syncMode: Output<Either<String, VideoSyncMode>>? = null

    /**
     * @param value The distance between two key frames. The value should be non-zero in the range [0&#46;5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
     */
    @JvmName("esvkjgkqksqnfefg")
    public suspend fun keyFrameInterval(`value`: Output<String>) {
        this.keyFrameInterval = value
    }

    /**
     * @param value An optional label for the codec. The label can be used to control muxing behavior.
     */
    @JvmName("gljovnexpyfokxpr")
    public suspend fun label(`value`: Output<String>) {
        this.label = value
    }

    /**
     * @param value A collection of output PNG image layers to be produced by the encoder.
     */
    @JvmName("otfjpproypxtngtx")
    public suspend fun layers(`value`: Output<List<PngLayerArgs>>) {
        this.layers = value
    }

    @JvmName("xcwympkukjclhage")
    public suspend fun layers(vararg values: Output<PngLayerArgs>) {
        this.layers = Output.all(values.asList())
    }

    /**
     * @param values A collection of output PNG image layers to be produced by the encoder.
     */
    @JvmName("ottxseggnkvslvcf")
    public suspend fun layers(values: List<Output<PngLayerArgs>>) {
        this.layers = Output.all(values)
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.PngImage'.
     */
    @JvmName("mdesluxfqnqkufwc")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value The position relative to transform preset start time in the input video at which to stop generating thumbnails. The value can be in ISO 8601 format (For example, PT5M30S to stop at 5 minutes and 30 seconds from start time), or a frame count (For example, 300 to stop at the 300th frame from the frame at start time. If this value is 1, it means only producing one thumbnail at start time), or a relative value to the stream duration (For example, 50% to stop at half of stream duration from start time). The default value is 100%, which means to stop at the end of the stream.
     */
    @JvmName("asmrjgiaalriplba")
    public suspend fun range(`value`: Output<String>) {
        this.range = value
    }

    /**
     * @param value The position in the input video from where to start generating thumbnails. The value can be in ISO 8601 format (For example, PT05S to start at 5 seconds), or a frame count (For example, 10 to start at the 10th frame), or a relative value to stream duration (For example, 10% to start at 10% of stream duration). Also supports a macro {Best}, which tells the encoder to select the best thumbnail from the first few seconds of the video and will only produce one thumbnail, no matter what other settings are for Step and Range. The default value is macro {Best}.
     */
    @JvmName("tqfgiggpvmbfwipm")
    public suspend fun start(`value`: Output<String>) {
        this.start = value
    }

    /**
     * @param value The intervals at which thumbnails are generated. The value can be in ISO 8601 format (For example, PT05S for one image every 5 seconds), or a frame count (For example, 30 for one image every 30 frames), or a relative value to stream duration (For example, 10% for one image every 10% of stream duration). Note: Step value will affect the first generated thumbnail, which may not be exactly the one specified at transform preset start time. This is due to the encoder, which tries to select the best thumbnail between start time and Step position from start time as the first output. As the default value is 10%, it means if stream has long duration, the first generated thumbnail might be far away from the one specified at start time. Try to select reasonable value for Step if the first thumbnail is expected close to start time, or set Range value at 1 if only one thumbnail is needed at start time.
     */
    @JvmName("wctdegmwucaxayfe")
    public suspend fun step(`value`: Output<String>) {
        this.step = value
    }

    /**
     * @param value The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
     */
    @JvmName("cxktyhtshkebhykj")
    public suspend fun stretchMode(`value`: Output<Either<String, StretchMode>>) {
        this.stretchMode = value
    }

    /**
     * @param value The Video Sync Mode
     */
    @JvmName("aohrdljykfjypxbo")
    public suspend fun syncMode(`value`: Output<Either<String, VideoSyncMode>>) {
        this.syncMode = value
    }

    /**
     * @param value The distance between two key frames. The value should be non-zero in the range [0&#46;5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
     */
    @JvmName("umjsogykhpbtqrod")
    public suspend fun keyFrameInterval(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyFrameInterval = mapped
    }

    /**
     * @param value An optional label for the codec. The label can be used to control muxing behavior.
     */
    @JvmName("wddwrupjxwgbkbuh")
    public suspend fun label(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.label = mapped
    }

    /**
     * @param value A collection of output PNG image layers to be produced by the encoder.
     */
    @JvmName("lhuxquvrgshbpndr")
    public suspend fun layers(`value`: List<PngLayerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.layers = mapped
    }

    /**
     * @param argument A collection of output PNG image layers to be produced by the encoder.
     */
    @JvmName("byvwpxwrrlsuflvw")
    public suspend fun layers(argument: List<suspend PngLayerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { PngLayerArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.layers = mapped
    }

    /**
     * @param argument A collection of output PNG image layers to be produced by the encoder.
     */
    @JvmName("rwtndhmvmlughshq")
    public suspend fun layers(vararg argument: suspend PngLayerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { PngLayerArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.layers = mapped
    }

    /**
     * @param argument A collection of output PNG image layers to be produced by the encoder.
     */
    @JvmName("vqmmdflkorlceavx")
    public suspend fun layers(argument: suspend PngLayerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PngLayerArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.layers = mapped
    }

    /**
     * @param values A collection of output PNG image layers to be produced by the encoder.
     */
    @JvmName("qhhjeunyxghbscup")
    public suspend fun layers(vararg values: PngLayerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.layers = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.PngImage'.
     */
    @JvmName("therwvlqvolelqbi")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    /**
     * @param value The position relative to transform preset start time in the input video at which to stop generating thumbnails. The value can be in ISO 8601 format (For example, PT5M30S to stop at 5 minutes and 30 seconds from start time), or a frame count (For example, 300 to stop at the 300th frame from the frame at start time. If this value is 1, it means only producing one thumbnail at start time), or a relative value to the stream duration (For example, 50% to stop at half of stream duration from start time). The default value is 100%, which means to stop at the end of the stream.
     */
    @JvmName("gkaypgwlplolfdvt")
    public suspend fun range(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.range = mapped
    }

    /**
     * @param value The position in the input video from where to start generating thumbnails. The value can be in ISO 8601 format (For example, PT05S to start at 5 seconds), or a frame count (For example, 10 to start at the 10th frame), or a relative value to stream duration (For example, 10% to start at 10% of stream duration). Also supports a macro {Best}, which tells the encoder to select the best thumbnail from the first few seconds of the video and will only produce one thumbnail, no matter what other settings are for Step and Range. The default value is macro {Best}.
     */
    @JvmName("vhbouetxbvjgunpj")
    public suspend fun start(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.start = mapped
    }

    /**
     * @param value The intervals at which thumbnails are generated. The value can be in ISO 8601 format (For example, PT05S for one image every 5 seconds), or a frame count (For example, 30 for one image every 30 frames), or a relative value to stream duration (For example, 10% for one image every 10% of stream duration). Note: Step value will affect the first generated thumbnail, which may not be exactly the one specified at transform preset start time. This is due to the encoder, which tries to select the best thumbnail between start time and Step position from start time as the first output. As the default value is 10%, it means if stream has long duration, the first generated thumbnail might be far away from the one specified at start time. Try to select reasonable value for Step if the first thumbnail is expected close to start time, or set Range value at 1 if only one thumbnail is needed at start time.
     */
    @JvmName("lmqinpffhumevawj")
    public suspend fun step(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.step = mapped
    }

    /**
     * @param value The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
     */
    @JvmName("jecnpmdysbtctbwh")
    public suspend fun stretchMode(`value`: Either<String, StretchMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stretchMode = mapped
    }

    /**
     * @param value The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
     */
    @JvmName("rossbflfcywjnhjr")
    public fun stretchMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, StretchMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stretchMode = mapped
    }

    /**
     * @param value The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
     */
    @JvmName("guevwjeygotqdeug")
    public fun stretchMode(`value`: StretchMode) {
        val toBeMapped = Either.ofRight<String, StretchMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stretchMode = mapped
    }

    /**
     * @param value The Video Sync Mode
     */
    @JvmName("qukyrhyddxapydnj")
    public suspend fun syncMode(`value`: Either<String, VideoSyncMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.syncMode = mapped
    }

    /**
     * @param value The Video Sync Mode
     */
    @JvmName("mhhyviisxcjbjfbh")
    public fun syncMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VideoSyncMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.syncMode = mapped
    }

    /**
     * @param value The Video Sync Mode
     */
    @JvmName("etbubcyjcmnvndbx")
    public fun syncMode(`value`: VideoSyncMode) {
        val toBeMapped = Either.ofRight<String, VideoSyncMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.syncMode = mapped
    }

    internal fun build(): PngImageArgs = PngImageArgs(
        keyFrameInterval = keyFrameInterval,
        label = label,
        layers = layers,
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
        range = range,
        start = start ?: throw PulumiNullFieldException("start"),
        step = step,
        stretchMode = stretchMode,
        syncMode = syncMode,
    )
}
