@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.SelectAudioTrackByAttributeArgs.builder
import com.pulumi.azurenative.media.kotlin.enums.AttributeFilter
import com.pulumi.azurenative.media.kotlin.enums.ChannelMapping
import com.pulumi.azurenative.media.kotlin.enums.TrackAttribute
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Select audio tracks from the input by specifying an attribute and an attribute filter.
 * @property attribute The TrackAttribute to filter the tracks by.
 * @property channelMapping Optional designation for single channel audio tracks.  Can be used to combine the tracks into stereo or multi-channel audio tracks.
 * @property filter The type of AttributeFilter to apply to the TrackAttribute in order to select the tracks.
 * @property filterValue The value to filter the tracks by.  Only used when AttributeFilter.ValueEquals is specified for the Filter property.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.SelectAudioTrackByAttribute'.
 */
public data class SelectAudioTrackByAttributeArgs(
    public val attribute: Output<Either<String, TrackAttribute>>,
    public val channelMapping: Output<Either<String, ChannelMapping>>? = null,
    public val filter: Output<Either<String, AttributeFilter>>,
    public val filterValue: Output<String>? = null,
    public val odataType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.SelectAudioTrackByAttributeArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.SelectAudioTrackByAttributeArgs =
        com.pulumi.azurenative.media.inputs.SelectAudioTrackByAttributeArgs.builder()
            .attribute(
                attribute.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .channelMapping(
                channelMapping?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .filter(
                filter.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .filterValue(filterValue?.applyValue({ args0 -> args0 }))
            .odataType(odataType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SelectAudioTrackByAttributeArgs].
 */
@PulumiTagMarker
public class SelectAudioTrackByAttributeArgsBuilder internal constructor() {
    private var attribute: Output<Either<String, TrackAttribute>>? = null

    private var channelMapping: Output<Either<String, ChannelMapping>>? = null

    private var filter: Output<Either<String, AttributeFilter>>? = null

    private var filterValue: Output<String>? = null

    private var odataType: Output<String>? = null

    /**
     * @param value The TrackAttribute to filter the tracks by.
     */
    @JvmName("rcxoirwcvotsrvsu")
    public suspend fun attribute(`value`: Output<Either<String, TrackAttribute>>) {
        this.attribute = value
    }

    /**
     * @param value Optional designation for single channel audio tracks.  Can be used to combine the tracks into stereo or multi-channel audio tracks.
     */
    @JvmName("ofpciwesxmxyhdin")
    public suspend fun channelMapping(`value`: Output<Either<String, ChannelMapping>>) {
        this.channelMapping = value
    }

    /**
     * @param value The type of AttributeFilter to apply to the TrackAttribute in order to select the tracks.
     */
    @JvmName("scaodyeuitupdtyi")
    public suspend fun filter(`value`: Output<Either<String, AttributeFilter>>) {
        this.filter = value
    }

    /**
     * @param value The value to filter the tracks by.  Only used when AttributeFilter.ValueEquals is specified for the Filter property.
     */
    @JvmName("gnrrdeferdmyihgk")
    public suspend fun filterValue(`value`: Output<String>) {
        this.filterValue = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.SelectAudioTrackByAttribute'.
     */
    @JvmName("wjphjwcwieydefbv")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value The TrackAttribute to filter the tracks by.
     */
    @JvmName("ioxusytxotsvfcsg")
    public suspend fun attribute(`value`: Either<String, TrackAttribute>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attribute = mapped
    }

    /**
     * @param value The TrackAttribute to filter the tracks by.
     */
    @JvmName("bxqcrxovibsdwtsa")
    public fun attribute(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TrackAttribute>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attribute = mapped
    }

    /**
     * @param value The TrackAttribute to filter the tracks by.
     */
    @JvmName("hdatejqdpgftwqjq")
    public fun attribute(`value`: TrackAttribute) {
        val toBeMapped = Either.ofRight<String, TrackAttribute>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attribute = mapped
    }

    /**
     * @param value Optional designation for single channel audio tracks.  Can be used to combine the tracks into stereo or multi-channel audio tracks.
     */
    @JvmName("eeuljmsekitifsmw")
    public suspend fun channelMapping(`value`: Either<String, ChannelMapping>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.channelMapping = mapped
    }

    /**
     * @param value Optional designation for single channel audio tracks.  Can be used to combine the tracks into stereo or multi-channel audio tracks.
     */
    @JvmName("hpuoyqpgtqhxhigp")
    public fun channelMapping(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ChannelMapping>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.channelMapping = mapped
    }

    /**
     * @param value Optional designation for single channel audio tracks.  Can be used to combine the tracks into stereo or multi-channel audio tracks.
     */
    @JvmName("euhqkgfhpnfmvqhq")
    public fun channelMapping(`value`: ChannelMapping) {
        val toBeMapped = Either.ofRight<String, ChannelMapping>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.channelMapping = mapped
    }

    /**
     * @param value The type of AttributeFilter to apply to the TrackAttribute in order to select the tracks.
     */
    @JvmName("jprnkjylogoglvcx")
    public suspend fun filter(`value`: Either<String, AttributeFilter>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filter = mapped
    }

    /**
     * @param value The type of AttributeFilter to apply to the TrackAttribute in order to select the tracks.
     */
    @JvmName("morjrtjlgtjdftjh")
    public fun filter(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AttributeFilter>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filter = mapped
    }

    /**
     * @param value The type of AttributeFilter to apply to the TrackAttribute in order to select the tracks.
     */
    @JvmName("niycajxspxtgoskj")
    public fun filter(`value`: AttributeFilter) {
        val toBeMapped = Either.ofRight<String, AttributeFilter>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filter = mapped
    }

    /**
     * @param value The value to filter the tracks by.  Only used when AttributeFilter.ValueEquals is specified for the Filter property.
     */
    @JvmName("dumbqpmsujqxjosh")
    public suspend fun filterValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filterValue = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.SelectAudioTrackByAttribute'.
     */
    @JvmName("ouxyxvppkpinwbwt")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    internal fun build(): SelectAudioTrackByAttributeArgs = SelectAudioTrackByAttributeArgs(
        attribute = attribute ?: throw PulumiNullFieldException("attribute"),
        channelMapping = channelMapping,
        filter = filter ?: throw PulumiNullFieldException("filter"),
        filterValue = filterValue,
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
    )
}
