@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.StreamingLocatorContentKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Class for content key in Streaming Locator
 * @property id ID of Content Key
 * @property labelReferenceInStreamingPolicy Label of Content Key as specified in the Streaming Policy
 * @property value Value of Content Key
 */
public data class StreamingLocatorContentKeyArgs(
    public val id: Output<String>,
    public val labelReferenceInStreamingPolicy: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.StreamingLocatorContentKeyArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.StreamingLocatorContentKeyArgs =
        com.pulumi.azurenative.media.inputs.StreamingLocatorContentKeyArgs.builder()
            .id(id.applyValue({ args0 -> args0 }))
            .labelReferenceInStreamingPolicy(labelReferenceInStreamingPolicy?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StreamingLocatorContentKeyArgs].
 */
@PulumiTagMarker
public class StreamingLocatorContentKeyArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var labelReferenceInStreamingPolicy: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value ID of Content Key
     */
    @JvmName("tymromypelpwehhq")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Label of Content Key as specified in the Streaming Policy
     */
    @JvmName("cyfmhnfnyfshqjdf")
    public suspend fun labelReferenceInStreamingPolicy(`value`: Output<String>) {
        this.labelReferenceInStreamingPolicy = value
    }

    /**
     * @param value Value of Content Key
     */
    @JvmName("mopmfbcrqgbpwxbq")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value ID of Content Key
     */
    @JvmName("utvgkfylkcoddxaa")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Label of Content Key as specified in the Streaming Policy
     */
    @JvmName("fxfvdxkqdkgifdxq")
    public suspend fun labelReferenceInStreamingPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labelReferenceInStreamingPolicy = mapped
    }

    /**
     * @param value Value of Content Key
     */
    @JvmName("tkergtoiwyavkxlb")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): StreamingLocatorContentKeyArgs = StreamingLocatorContentKeyArgs(
        id = id ?: throw PulumiNullFieldException("id"),
        labelReferenceInStreamingPolicy = labelReferenceInStreamingPolicy,
        `value` = `value`,
    )
}
