@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.StreamingPolicyFairPlayConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Class to specify configurations of FairPlay in Streaming Policy
 * @property allowPersistentLicense All license to be persistent or not
 * @property customLicenseAcquisitionUrlTemplate Template for the URL of the custom service delivering licenses to end user players.  Not required when using Azure Media Services for issuing licenses.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
 */
public data class StreamingPolicyFairPlayConfigurationArgs(
    public val allowPersistentLicense: Output<Boolean>,
    public val customLicenseAcquisitionUrlTemplate: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.StreamingPolicyFairPlayConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.StreamingPolicyFairPlayConfigurationArgs =
        com.pulumi.azurenative.media.inputs.StreamingPolicyFairPlayConfigurationArgs.builder()
            .allowPersistentLicense(allowPersistentLicense.applyValue({ args0 -> args0 }))
            .customLicenseAcquisitionUrlTemplate(
                customLicenseAcquisitionUrlTemplate?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [StreamingPolicyFairPlayConfigurationArgs].
 */
@PulumiTagMarker
public class StreamingPolicyFairPlayConfigurationArgsBuilder internal constructor() {
    private var allowPersistentLicense: Output<Boolean>? = null

    private var customLicenseAcquisitionUrlTemplate: Output<String>? = null

    /**
     * @param value All license to be persistent or not
     */
    @JvmName("tbqyvmkwrsscgifx")
    public suspend fun allowPersistentLicense(`value`: Output<Boolean>) {
        this.allowPersistentLicense = value
    }

    /**
     * @param value Template for the URL of the custom service delivering licenses to end user players.  Not required when using Azure Media Services for issuing licenses.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
     */
    @JvmName("nlxnafaouswofjwe")
    public suspend fun customLicenseAcquisitionUrlTemplate(`value`: Output<String>) {
        this.customLicenseAcquisitionUrlTemplate = value
    }

    /**
     * @param value All license to be persistent or not
     */
    @JvmName("osnbgduqmjmtyugk")
    public suspend fun allowPersistentLicense(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowPersistentLicense = mapped
    }

    /**
     * @param value Template for the URL of the custom service delivering licenses to end user players.  Not required when using Azure Media Services for issuing licenses.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
     */
    @JvmName("ddfxbnfmtkmbftis")
    public suspend fun customLicenseAcquisitionUrlTemplate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customLicenseAcquisitionUrlTemplate = mapped
    }

    internal fun build(): StreamingPolicyFairPlayConfigurationArgs =
        StreamingPolicyFairPlayConfigurationArgs(
            allowPersistentLicense = allowPersistentLicense ?: throw
                PulumiNullFieldException("allowPersistentLicense"),
            customLicenseAcquisitionUrlTemplate = customLicenseAcquisitionUrlTemplate,
        )
}
