@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Describes Advanced Audio Codec (AAC) audio encoding settings.
 * @property bitrate The bitrate, in bits per second, of the output encoded audio.
 * @property channels The number of channels in the audio.
 * @property label An optional label for the codec. The label can be used to control muxing behavior.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.AacAudio'.
 * @property profile The encoding profile to be used when encoding audio with AAC.
 * @property samplingRate The sampling rate to use for encoding in hertz.
 */
public data class AacAudioResponse(
    public val bitrate: Int? = null,
    public val channels: Int? = null,
    public val label: String? = null,
    public val odataType: String,
    public val profile: String? = null,
    public val samplingRate: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.AacAudioResponse): AacAudioResponse = AacAudioResponse(
            bitrate = javaType.bitrate().map({ args0 -> args0 }).orElse(null),
            channels = javaType.channels().map({ args0 -> args0 }).orElse(null),
            label = javaType.label().map({ args0 -> args0 }).orElse(null),
            odataType = javaType.odataType(),
            profile = javaType.profile().map({ args0 -> args0 }).orElse(null),
            samplingRate = javaType.samplingRate().map({ args0 -> args0 }).orElse(null),
        )
    }
}
