@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property defaultAction The behavior for IP access control in Key Delivery.
 * @property ipAllowList The IP allow list for access control in Key Delivery. If the default action is set to 'Allow', the IP allow list must be empty.
 */
public data class AccessControlResponse(
    public val defaultAction: String? = null,
    public val ipAllowList: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.AccessControlResponse): AccessControlResponse = AccessControlResponse(
            defaultAction = javaType.defaultAction().map({ args0 -> args0 }).orElse(null),
            ipAllowList = javaType.ipAllowList().map({ args0 -> args0 }),
        )
    }
}
