@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The Audio Analyzer preset applies a pre-defined set of AI-based analysis operations, including speech transcription. Currently, the preset supports processing of content with a single audio track.
 * @property audioLanguage The language for the audio payload in the input using the BCP-47 format of 'language tag-region' (e.g: 'en-US').  If you know the language of your content, it is recommended that you specify it. The language must be specified explicitly for AudioAnalysisMode::Basic, since automatic language detection is not included in basic mode. If the language isn't specified or set to null, automatic language detection will choose the first language detected and process with the selected language for the duration of the file. It does not currently support dynamically switching between languages after the first language is detected. The automatic detection works best with audio recordings with clearly discernable speech. If automatic detection fails to find the language, transcription would fallback to 'en-US'." The list of supported languages is available here: https://go.microsoft.com/fwlink/?linkid=2109463
 * @property experimentalOptions Dictionary containing key value pairs for parameters not exposed in the preset itself
 * @property mode Determines the set of audio analysis operations to be performed. If unspecified, the Standard AudioAnalysisMode would be chosen.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.AudioAnalyzerPreset'.
 */
public data class AudioAnalyzerPresetResponse(
    public val audioLanguage: String? = null,
    public val experimentalOptions: Map<String, String>? = null,
    public val mode: String? = null,
    public val odataType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.AudioAnalyzerPresetResponse): AudioAnalyzerPresetResponse = AudioAnalyzerPresetResponse(
            audioLanguage = javaType.audioLanguage().map({ args0 -> args0 }).orElse(null),
            experimentalOptions = javaType.experimentalOptions().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            mode = javaType.mode().map({ args0 -> args0 }).orElse(null),
            odataType = javaType.odataType(),
        )
    }
}
