@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Defines the common properties for all audio codecs.
 * @property bitrate The bitrate, in bits per second, of the output encoded audio.
 * @property channels The number of channels in the audio.
 * @property label An optional label for the codec. The label can be used to control muxing behavior.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.Audio'.
 * @property samplingRate The sampling rate to use for encoding in hertz.
 */
public data class AudioResponse(
    public val bitrate: Int? = null,
    public val channels: Int? = null,
    public val label: String? = null,
    public val odataType: String,
    public val samplingRate: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.AudioResponse): AudioResponse = AudioResponse(
            bitrate = javaType.bitrate().map({ args0 -> args0 }).orElse(null),
            channels = javaType.channels().map({ args0 -> args0 }).orElse(null),
            label = javaType.label().map({ args0 -> args0 }).orElse(null),
            odataType = javaType.odataType(),
            samplingRate = javaType.samplingRate().map({ args0 -> args0 }).orElse(null),
        )
    }
}
