@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A TrackSelection to select audio tracks.
 * @property channelMapping Optional designation for single channel audio tracks.  Can be used to combine the tracks into stereo or multi-channel audio tracks.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.AudioTrackDescriptor'.
 */
public data class AudioTrackDescriptorResponse(
    public val channelMapping: String? = null,
    public val odataType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.AudioTrackDescriptorResponse): AudioTrackDescriptorResponse = AudioTrackDescriptorResponse(
            channelMapping = javaType.channelMapping().map({ args0 -> args0 }).orElse(null),
            odataType = javaType.odataType(),
        )
    }
}
