@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.Suppress

/**
 * Class to specify DRM configurations of CommonEncryptionCbcs scheme in Streaming Policy
 * @property fairPlay FairPlay configurations
 * @property playReady PlayReady configurations
 * @property widevine Widevine configurations
 */
public data class CbcsDrmConfigurationResponse(
    public val fairPlay: StreamingPolicyFairPlayConfigurationResponse? = null,
    public val playReady: StreamingPolicyPlayReadyConfigurationResponse? = null,
    public val widevine: StreamingPolicyWidevineConfigurationResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.CbcsDrmConfigurationResponse): CbcsDrmConfigurationResponse = CbcsDrmConfigurationResponse(
            fairPlay = javaType.fairPlay().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.StreamingPolicyFairPlayConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            playReady = javaType.playReady().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.StreamingPolicyPlayReadyConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            widevine = javaType.widevine().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.StreamingPolicyWidevineConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
