@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Specifies a configuration for PlayReady licenses.
 * @property licenses The PlayReady licenses.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.ContentKeyPolicyPlayReadyConfiguration'.
 * @property responseCustomData The custom response data.
 */
public data class ContentKeyPolicyPlayReadyConfigurationResponse(
    public val licenses: List<ContentKeyPolicyPlayReadyLicenseResponse>,
    public val odataType: String,
    public val responseCustomData: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.ContentKeyPolicyPlayReadyConfigurationResponse): ContentKeyPolicyPlayReadyConfigurationResponse =
            ContentKeyPolicyPlayReadyConfigurationResponse(
                licenses = javaType.licenses().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.media.kotlin.outputs.ContentKeyPolicyPlayReadyLicenseResponse.Companion.toKotlin(args0)
                    })
                }),
                odataType = javaType.odataType(),
                responseCustomData = javaType.responseCustomData().map({ args0 -> args0 }).orElse(null),
            )
    }
}
