@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Specifies that the content key ID is specified in the PlayReady configuration.
 * @property keyId The content key ID.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier'.
 */
public data class ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierResponse(
    public val keyId: String,
    public val odataType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierResponse): ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierResponse =
            ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierResponse(
                keyId = javaType.keyId(),
                odataType = javaType.odataType(),
            )
    }
}
