@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Configures the Play Right in the PlayReady license.
 * @property agcAndColorStripeRestriction Configures Automatic Gain Control (AGC) and Color Stripe in the license. Must be between 0 and 3 inclusive.
 * @property allowPassingVideoContentToUnknownOutput Configures Unknown output handling settings of the license.
 * @property analogVideoOpl Specifies the output protection level for compressed digital audio.
 * @property compressedDigitalAudioOpl Specifies the output protection level for compressed digital audio.
 * @property compressedDigitalVideoOpl Specifies the output protection level for compressed digital video.
 * @property digitalVideoOnlyContentRestriction Enables the Image Constraint For Analog Component Video Restriction in the license.
 * @property explicitAnalogTelevisionOutputRestriction Configures the Explicit Analog Television Output Restriction in the license. Configuration data must be between 0 and 3 inclusive.
 * @property firstPlayExpiration The amount of time that the license is valid after the license is first used to play content.
 * @property imageConstraintForAnalogComponentVideoRestriction Enables the Image Constraint For Analog Component Video Restriction in the license.
 * @property imageConstraintForAnalogComputerMonitorRestriction Enables the Image Constraint For Analog Component Video Restriction in the license.
 * @property scmsRestriction Configures the Serial Copy Management System (SCMS) in the license. Must be between 0 and 3 inclusive.
 * @property uncompressedDigitalAudioOpl Specifies the output protection level for uncompressed digital audio.
 * @property uncompressedDigitalVideoOpl Specifies the output protection level for uncompressed digital video.
 */
public data class ContentKeyPolicyPlayReadyPlayRightResponse(
    public val agcAndColorStripeRestriction: Int? = null,
    public val allowPassingVideoContentToUnknownOutput: String,
    public val analogVideoOpl: Int? = null,
    public val compressedDigitalAudioOpl: Int? = null,
    public val compressedDigitalVideoOpl: Int? = null,
    public val digitalVideoOnlyContentRestriction: Boolean,
    public val explicitAnalogTelevisionOutputRestriction: ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionResponse? = null,
    public val firstPlayExpiration: String? = null,
    public val imageConstraintForAnalogComponentVideoRestriction: Boolean,
    public val imageConstraintForAnalogComputerMonitorRestriction: Boolean,
    public val scmsRestriction: Int? = null,
    public val uncompressedDigitalAudioOpl: Int? = null,
    public val uncompressedDigitalVideoOpl: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.ContentKeyPolicyPlayReadyPlayRightResponse): ContentKeyPolicyPlayReadyPlayRightResponse = ContentKeyPolicyPlayReadyPlayRightResponse(
            agcAndColorStripeRestriction = javaType.agcAndColorStripeRestriction().map({ args0 ->
                args0
            }).orElse(null),
            allowPassingVideoContentToUnknownOutput = javaType.allowPassingVideoContentToUnknownOutput(),
            analogVideoOpl = javaType.analogVideoOpl().map({ args0 -> args0 }).orElse(null),
            compressedDigitalAudioOpl = javaType.compressedDigitalAudioOpl().map({ args0 ->
                args0
            }).orElse(null),
            compressedDigitalVideoOpl = javaType.compressedDigitalVideoOpl().map({ args0 ->
                args0
            }).orElse(null),
            digitalVideoOnlyContentRestriction = javaType.digitalVideoOnlyContentRestriction(),
            explicitAnalogTelevisionOutputRestriction = javaType.explicitAnalogTelevisionOutputRestriction().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            firstPlayExpiration = javaType.firstPlayExpiration().map({ args0 -> args0 }).orElse(null),
            imageConstraintForAnalogComponentVideoRestriction = javaType.imageConstraintForAnalogComponentVideoRestriction(),
            imageConstraintForAnalogComputerMonitorRestriction = javaType.imageConstraintForAnalogComputerMonitorRestriction(),
            scmsRestriction = javaType.scmsRestriction().map({ args0 -> args0 }).orElse(null),
            uncompressedDigitalAudioOpl = javaType.uncompressedDigitalAudioOpl().map({ args0 ->
                args0
            }).orElse(null),
            uncompressedDigitalVideoOpl = javaType.uncompressedDigitalVideoOpl().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
