@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Represents a token restriction. Provided token must match these requirements for successful license or key delivery.
 * @property alternateVerificationKeys A list of alternative verification keys.
 * @property audience The audience for the token.
 * @property issuer The token issuer.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.ContentKeyPolicyTokenRestriction'.
 * @property openIdConnectDiscoveryDocument The OpenID connect discovery document.
 * @property primaryVerificationKey The primary verification key.
 * @property requiredClaims A list of required token claims.
 * @property restrictionTokenType The type of token.
 */
public data class ContentKeyPolicyTokenRestrictionResponse(
    public val alternateVerificationKeys: List<Any>? = null,
    public val audience: String,
    public val issuer: String,
    public val odataType: String,
    public val openIdConnectDiscoveryDocument: String? = null,
    public val primaryVerificationKey: Any,
    public val requiredClaims: List<ContentKeyPolicyTokenClaimResponse>? = null,
    public val restrictionTokenType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.ContentKeyPolicyTokenRestrictionResponse): ContentKeyPolicyTokenRestrictionResponse = ContentKeyPolicyTokenRestrictionResponse(
            alternateVerificationKeys = javaType.alternateVerificationKeys().map({ args0 -> args0 }),
            audience = javaType.audience(),
            issuer = javaType.issuer(),
            odataType = javaType.odataType(),
            openIdConnectDiscoveryDocument = javaType.openIdConnectDiscoveryDocument().map({ args0 ->
                args0
            }).orElse(null),
            primaryVerificationKey = javaType.primaryVerificationKey(),
            requiredClaims = javaType.requiredClaims().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.ContentKeyPolicyTokenClaimResponse.Companion.toKotlin(args0)
                })
            }),
            restrictionTokenType = javaType.restrictionTokenType(),
        )
    }
}
