@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Represents a ContentKeyPolicyConfiguration that is unavailable in the current API version.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.ContentKeyPolicyUnknownConfiguration'.
 */
public data class ContentKeyPolicyUnknownConfigurationResponse(
    public val odataType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.ContentKeyPolicyUnknownConfigurationResponse): ContentKeyPolicyUnknownConfigurationResponse = ContentKeyPolicyUnknownConfigurationResponse(
            odataType = javaType.odataType(),
        )
    }
}
