@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A codec flag, which tells the encoder to copy the input video bitstream without re-encoding.
 * @property label An optional label for the codec. The label can be used to control muxing behavior.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.CopyVideo'.
 */
public data class CopyVideoResponse(
    public val label: String? = null,
    public val odataType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.CopyVideoResponse): CopyVideoResponse = CopyVideoResponse(
            label = javaType.label().map({ args0 -> args0 }).orElse(null),
            odataType = javaType.odataType(),
        )
    }
}
