@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The client access policy.
 * @property clientAccessPolicy The content of clientaccesspolicy.xml used by Silverlight.
 * @property crossDomainPolicy The content of crossdomain.xml used by Silverlight.
 */
public data class CrossSiteAccessPoliciesResponse(
    public val clientAccessPolicy: String? = null,
    public val crossDomainPolicy: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.CrossSiteAccessPoliciesResponse): CrossSiteAccessPoliciesResponse = CrossSiteAccessPoliciesResponse(
            clientAccessPolicy = javaType.clientAccessPolicy().map({ args0 -> args0 }).orElse(null),
            crossDomainPolicy = javaType.crossDomainPolicy().map({ args0 -> args0 }).orElse(null),
        )
    }
}
